/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.binary;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@XObject(value="binary-store")
public class BinaryManagerRootDescriptor {
    public static final String BINARY_STORE = "binary-store";
    public static final String DIGEST = "digest";
    public static final String DEPTH = "depth";
    @XNode(value="digest")
    public String digest;
    @XNode(value="depth")
    public int depth;

    public void write(File out) throws IOException {
        DocumentBuilder parser;
        try {
            parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException().initCause(e);
        }
        Document doc = parser.newDocument();
        Element root = doc.createElement(BINARY_STORE);
        doc.appendChild(root);
        root.appendChild(doc.createElement(DIGEST)).appendChild(doc.createTextNode(this.digest));
        root.appendChild(doc.createElement(DEPTH)).appendChild(doc.createTextNode(String.valueOf(this.depth)));
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "no");
            trans.setOutputProperty("indent", "yes");
            StreamResult outputTarget = new StreamResult(new FileOutputStream(out));
            trans.transform(new DOMSource(doc), outputTarget);
        }
        catch (TransformerException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }
}

