/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css;

import com.phloc.commons.CGlobal;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.lang.EnumHelper;
import com.phloc.commons.name.IHasName;
import com.phloc.css.ECSSMetaUnit;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSVersionAware;
import java.text.NumberFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ECSSUnit implements IHasName,
ICSSVersionAware
{
    EM("em", ECSSMetaUnit.FONT_RELATIVE_LENGTH),
    EX("ex", ECSSMetaUnit.FONT_RELATIVE_LENGTH),
    PX("px", ECSSMetaUnit.ABSOLUTE_LENGTH),
    REM("rem", ECSSMetaUnit.FONT_RELATIVE_LENGTH, ECSSVersion.CSS30),
    VW("vw", ECSSMetaUnit.VIEWPORT_RELATIVE_LENGTH, ECSSVersion.CSS30),
    VH("vh", ECSSMetaUnit.VIEWPORT_RELATIVE_LENGTH, ECSSVersion.CSS30),
    VMIN("vmin", ECSSMetaUnit.VIEWPORT_RELATIVE_LENGTH, ECSSVersion.CSS30),
    CH("ch", ECSSMetaUnit.FONT_RELATIVE_LENGTH, ECSSVersion.CSS30),
    LENGTH_IN("in", ECSSMetaUnit.ABSOLUTE_LENGTH),
    LENGTH_CM("cm", ECSSMetaUnit.ABSOLUTE_LENGTH),
    LENGTH_MM("mm", ECSSMetaUnit.ABSOLUTE_LENGTH),
    LENGTH_PT("pt", ECSSMetaUnit.ABSOLUTE_LENGTH),
    LENGTH_PC("pc", ECSSMetaUnit.ABSOLUTE_LENGTH),
    PERCENTAGE("%", ECSSMetaUnit.PERCENTAGE),
    ANGLE_DEG("deg", ECSSMetaUnit.ANGLE),
    ANGLE_RAD("rad", ECSSMetaUnit.ANGLE),
    ANGLE_GRAD("grad", ECSSMetaUnit.ANGLE),
    ANGLE_TURN("turn", ECSSMetaUnit.ANGLE, ECSSVersion.CSS30),
    TIME_MS("ms", ECSSMetaUnit.TIME),
    TIME_S("s", ECSSMetaUnit.TIME),
    FREQ_HZ("hz", ECSSMetaUnit.FREQUENZY),
    FREQ_KHZ("khz", ECSSMetaUnit.FREQUENZY),
    DPI("dpi", ECSSMetaUnit.RESOLUTION, ECSSVersion.CSS30),
    DPCM("dpcm", ECSSMetaUnit.RESOLUTION, ECSSVersion.CSS30),
    DPPX("dppx", ECSSMetaUnit.RESOLUTION, ECSSVersion.CSS30);

    public static final ECSSUnit LENGTH_PX;
    private final String m_sName;
    private final ECSSMetaUnit m_eMetaUnit;
    private final ECSSVersion m_eVersion;

    private ECSSUnit(String string2, ECSSMetaUnit eCSSMetaUnit) {
        this(string2, eCSSMetaUnit, ECSSVersion.CSS21);
    }

    private ECSSUnit(@Nonnull String string2, ECSSMetaUnit eCSSMetaUnit, ECSSVersion eCSSVersion) {
        this.m_sName = string2;
        this.m_eMetaUnit = eCSSMetaUnit;
        this.m_eVersion = eCSSVersion;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Nonnull
    public ECSSMetaUnit getMetaUnit() {
        return this.m_eMetaUnit;
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return this.m_eVersion;
    }

    @Nonnull
    @Nonempty
    public String format(int n) {
        return Integer.toString(n) + this.m_sName;
    }

    @Nonnull
    @Nonempty
    public String format(double d) {
        return NumberFormat.getNumberInstance(CGlobal.LOCALE_FIXED_NUMBER_FORMAT).format(d) + this.m_sName;
    }

    @Nullable
    public static ECSSUnit getFromNameOrNull(@Nullable String string) {
        return (ECSSUnit)EnumHelper.getFromNameOrNull(ECSSUnit.class, (String)string);
    }

    @Nonnull
    @Nonempty
    public static String em(int n) {
        return EM.format(n);
    }

    @Nonnull
    @Nonempty
    public static String em(double d) {
        return EM.format(d);
    }

    @Nonnull
    @Nonempty
    public static String ex(int n) {
        return EX.format(n);
    }

    @Nonnull
    @Nonempty
    public static String ex(double d) {
        return EX.format(d);
    }

    @Nonnull
    @Nonempty
    public static String px(int n) {
        return PX.format(n);
    }

    @Nonnull
    @Nonempty
    public static String px(double d) {
        return PX.format(d);
    }

    @Nonnull
    @Nonempty
    public static String rem(int n) {
        return REM.format(n);
    }

    @Nonnull
    @Nonempty
    public static String rem(double d) {
        return REM.format(d);
    }

    @Nonnull
    @Nonempty
    public static String vw(int n) {
        return VW.format(n);
    }

    @Nonnull
    @Nonempty
    public static String vw(double d) {
        return VW.format(d);
    }

    @Nonnull
    @Nonempty
    public static String vh(int n) {
        return VH.format(n);
    }

    @Nonnull
    @Nonempty
    public static String vh(double d) {
        return VH.format(d);
    }

    @Nonnull
    @Nonempty
    public static String vmin(int n) {
        return VMIN.format(n);
    }

    @Nonnull
    @Nonempty
    public static String vmin(double d) {
        return VMIN.format(d);
    }

    @Nonnull
    @Nonempty
    public static String ch(int n) {
        return CH.format(n);
    }

    @Nonnull
    @Nonempty
    public static String ch(double d) {
        return CH.format(d);
    }

    @Nonnull
    @Nonempty
    public static String in(int n) {
        return LENGTH_IN.format(n);
    }

    @Nonnull
    @Nonempty
    public static String in(double d) {
        return LENGTH_IN.format(d);
    }

    @Nonnull
    @Nonempty
    public static String cm(int n) {
        return LENGTH_CM.format(n);
    }

    @Nonnull
    @Nonempty
    public static String cm(double d) {
        return LENGTH_CM.format(d);
    }

    @Nonnull
    @Nonempty
    public static String mm(int n) {
        return LENGTH_MM.format(n);
    }

    @Nonnull
    @Nonempty
    public static String mm(double d) {
        return LENGTH_MM.format(d);
    }

    @Nonnull
    @Nonempty
    public static String pt(int n) {
        return LENGTH_PT.format(n);
    }

    @Nonnull
    @Nonempty
    public static String pt(double d) {
        return LENGTH_PT.format(d);
    }

    @Nonnull
    @Nonempty
    public static String pc(int n) {
        return LENGTH_PC.format(n);
    }

    @Nonnull
    @Nonempty
    public static String pc(double d) {
        return LENGTH_PC.format(d);
    }

    @Nonnull
    @Nonempty
    public static String perc(int n) {
        return PERCENTAGE.format(n);
    }

    @Nonnull
    @Nonempty
    public static String perc(double d) {
        return PERCENTAGE.format(d);
    }

    @Nonnull
    @Nonempty
    public static String deg(int n) {
        return ANGLE_DEG.format(n);
    }

    @Nonnull
    @Nonempty
    public static String deg(double d) {
        return ANGLE_DEG.format(d);
    }

    @Nonnull
    @Nonempty
    public static String rad(int n) {
        return ANGLE_RAD.format(n);
    }

    @Nonnull
    @Nonempty
    public static String rad(double d) {
        return ANGLE_RAD.format(d);
    }

    @Nonnull
    @Nonempty
    public static String grad(int n) {
        return ANGLE_GRAD.format(n);
    }

    @Nonnull
    @Nonempty
    public static String grad(double d) {
        return ANGLE_GRAD.format(d);
    }

    @Nonnull
    @Nonempty
    public static String turn(int n) {
        return ANGLE_TURN.format(n);
    }

    @Nonnull
    @Nonempty
    public static String turn(double d) {
        return ANGLE_TURN.format(d);
    }

    @Nonnull
    @Nonempty
    public static String ms(int n) {
        return TIME_MS.format(n);
    }

    @Nonnull
    @Nonempty
    public static String ms(double d) {
        return TIME_MS.format(d);
    }

    @Nonnull
    @Nonempty
    public static String s(int n) {
        return TIME_S.format(n);
    }

    @Nonnull
    @Nonempty
    public static String s(double d) {
        return TIME_S.format(d);
    }

    @Nonnull
    @Nonempty
    public static String hz(int n) {
        return FREQ_HZ.format(n);
    }

    @Nonnull
    @Nonempty
    public static String hz(double d) {
        return FREQ_HZ.format(d);
    }

    @Nonnull
    @Nonempty
    public static String khz(int n) {
        return FREQ_KHZ.format(n);
    }

    @Nonnull
    @Nonempty
    public static String khz(double d) {
        return FREQ_KHZ.format(d);
    }

    @Nonnull
    @Nonempty
    public static String dpi(int n) {
        return DPI.format(n);
    }

    @Nonnull
    @Nonempty
    public static String dpi(double d) {
        return DPI.format(d);
    }

    @Nonnull
    @Nonempty
    public static String dpcm(int n) {
        return DPCM.format(n);
    }

    @Nonnull
    @Nonempty
    public static String dpcm(double d) {
        return DPCM.format(d);
    }

    @Nonnull
    @Nonempty
    public static String dppx(int n) {
        return DPPX.format(n);
    }

    @Nonnull
    @Nonempty
    public static String dppx(double d) {
        return DPPX.format(d);
    }

    static {
        LENGTH_PX = PX;
    }
}

