/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class EncryptionKeyEncoder {
    public static byte[] encode(EncryptionKey key) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        aos.writeObject((Object)EncryptionKeyEncoder.encodeSequence(key));
        aos.close();
        return baos.toByteArray();
    }

    protected static DERSequence encodeSequence(EncryptionKey key) {
        DERSequence vector = new DERSequence();
        vector.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)DERInteger.valueOf((int)key.getKeyType().getOrdinal())));
        vector.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)new DEROctetString(key.getKeyValue())));
        return vector;
    }
}

