/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.javascript;

import java.nio.CharBuffer;

public class JSEncoder {
    private static final char[] ENCODE_HEX = "0123456789ABCDEF".toCharArray();
    private static final char[] ENCODE_QUOT = "\\\"".toCharArray();
    private static final char[] ENCODE_LF = "\\n".toCharArray();
    private static final char[] ENCODE_BC = "\\b".toCharArray();
    private static final char[] ENCODE_FF = "\\f".toCharArray();
    private static final char[] ENCODE_CR = "\\r".toCharArray();
    private static final char[] ENCODE_TAB = "\\t".toCharArray();
    private static final char[] ENCODE_BS = "\\\\".toCharArray();
    private static final char[] ENCODE_FS = "\\/".toCharArray();
    private static final char[] ENCODE_HM = "\\u002D".toCharArray();
    private static final char[] ENCODE_RB = "\\u005D".toCharArray();
    private static final char[] ENCODE_LT = "\\u003C".toCharArray();
    private static final char[] ENCODE_GT = "\\u003E".toCharArray();
    private static final CharBuffer ENCODE_QUOT_CB = CharBuffer.wrap(ENCODE_QUOT);
    private static final CharBuffer ENCODE_LF_CB = CharBuffer.wrap(ENCODE_LF);
    private static final CharBuffer ENCODE_BC_CB = CharBuffer.wrap(ENCODE_BC);
    private static final CharBuffer ENCODE_FF_CB = CharBuffer.wrap(ENCODE_FF);
    private static final CharBuffer ENCODE_CR_CB = CharBuffer.wrap(ENCODE_CR);
    private static final CharBuffer ENCODE_TAB_CB = CharBuffer.wrap(ENCODE_TAB);
    private static final CharBuffer ENCODE_BS_CB = CharBuffer.wrap(ENCODE_BS);
    private static final CharBuffer ENCODE_FS_CB = CharBuffer.wrap(ENCODE_FS);
    private static final CharBuffer ENCODE_HM_CB = CharBuffer.wrap(ENCODE_HM);
    private static final CharBuffer ENCODE_RB_CB = CharBuffer.wrap(ENCODE_RB);
    private static final CharBuffer ENCODE_LT_CB = CharBuffer.wrap(ENCODE_LT);
    private static final CharBuffer ENCODE_GT_CB = CharBuffer.wrap(ENCODE_GT);

    public static boolean compile(char c) {
        return c != '\b' && !(c == '\f' | c == '\t') && c != '\n' && c != '\r' && c != '\"' && c != '\\' && c != '/' && c != ']' && c != '<' && c != '>' && c != '&' && c != '-' && c >= ' ' && (c <= '\ud7ff' || c >= '\ue000') && c <= '\ufffd' && c <= '\u00ff';
    }

    public static CharBuffer encodeCharBuffer(char c) {
        switch (c) {
            case '\b': {
                return ENCODE_BC_CB;
            }
            case '\f': {
                return ENCODE_FF_CB;
            }
            case '\t': {
                return ENCODE_TAB_CB;
            }
            case '\n': {
                return ENCODE_LF_CB;
            }
            case '\r': {
                return ENCODE_CR_CB;
            }
            case '\"': {
                return ENCODE_QUOT_CB;
            }
            case '\\': {
                return ENCODE_BS_CB;
            }
            case '/': {
                return ENCODE_FS_CB;
            }
            case '-': {
                return ENCODE_HM_CB;
            }
            case ']': {
                return ENCODE_RB_CB;
            }
            case '<': {
                return ENCODE_LT_CB;
            }
            case '>': {
                return ENCODE_GT_CB;
            }
        }
        char[] ret = new char[]{'\\', 'u', ENCODE_HEX[c >> 12 & 0xF], ENCODE_HEX[c >> 8 & 0xF], ENCODE_HEX[c >> 4 & 0xF], ENCODE_HEX[c & 0xF]};
        return CharBuffer.wrap(ret);
    }

    public char[] encode(char c) {
        switch (c) {
            case '\b': {
                return ENCODE_BC;
            }
            case '\f': {
                return ENCODE_FF;
            }
            case '\t': {
                return ENCODE_TAB;
            }
            case '\n': {
                return ENCODE_LF;
            }
            case '\r': {
                return ENCODE_CR;
            }
            case '\"': {
                return ENCODE_QUOT;
            }
            case '\\': {
                return ENCODE_BS;
            }
            case '/': {
                return ENCODE_FS;
            }
            case '-': {
                return ENCODE_HM;
            }
            case ']': {
                return ENCODE_RB;
            }
            case '<': {
                return ENCODE_LT;
            }
            case '>': {
                return ENCODE_GT;
            }
        }
        char[] ret = new char[]{'\\', 'u', ENCODE_HEX[c >> 12 & 0xF], ENCODE_HEX[c >> 8 & 0xF], ENCODE_HEX[c >> 4 & 0xF], ENCODE_HEX[c & 0xF]};
        return ret;
    }
}

