/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.servlet;

import com.sun.jersey.api.core.ApplicationAdapter;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import org.nuxeo.ecm.platform.rendering.api.RenderingEngine;
import org.nuxeo.ecm.platform.rendering.api.ResourceLocator;
import org.nuxeo.ecm.platform.rendering.fm.FreemarkerEngine;
import org.nuxeo.ecm.webengine.jaxrs.ApplicationHost;
import org.nuxeo.ecm.webengine.jaxrs.ApplicationManager;
import org.nuxeo.ecm.webengine.jaxrs.Reloadable;
import org.nuxeo.ecm.webengine.jaxrs.Utils;
import org.nuxeo.ecm.webengine.jaxrs.servlet.ManagedServlet;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ServletDescriptor;
import org.nuxeo.ecm.webengine.jaxrs.views.ResourceContext;
import org.osgi.framework.Bundle;

public class ApplicationServlet
extends HttpServlet
implements ManagedServlet,
Reloadable,
ResourceLocator {
    private static final long serialVersionUID = 1L;
    protected volatile boolean isDirty = false;
    protected Bundle bundle;
    protected ApplicationHost app;
    protected ServletContainer container;
    protected String resourcesPrefix;

    @Override
    public void setDescriptor(ServletDescriptor sd) {
        this.bundle = sd.getBundle();
    }

    public void init(ServletConfig config) throws ServletException {
        String name;
        super.init(config);
        this.resourcesPrefix = config.getInitParameter("resources.prefix");
        if (this.resourcesPrefix == null) {
            this.resourcesPrefix = "/skin";
        }
        if ((name = config.getInitParameter("application.name")) == null) {
            name = "default";
        }
        this.app = ApplicationManager.getInstance().getOrCreateApplication(name);
        Enumeration en = config.getInitParameterNames();
        while (en.hasMoreElements()) {
            String n = (String)en.nextElement();
            String v = config.getInitParameter(n);
            if (!Boolean.TRUE.toString().equals(v) && !Boolean.FALSE.toString().equals(v)) continue;
            this.app.getFeatures().put(n, Boolean.valueOf(v));
        }
        this.container = this.createServletContainer(this.app);
        this.initContainer(config);
        this.app.setRendering(this.initRendering(config));
        this.app.addReloadListener(this);
    }

    public void destroy() {
        this.destroyContainer();
        this.destroyRendering();
        this.container = null;
        this.app = null;
        this.bundle = null;
        this.resourcesPrefix = null;
    }

    @Override
    public synchronized void reload() {
        this.isDirty = true;
    }

    public RenderingEngine getRenderingEngine() {
        return this.app.getRendering();
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public ServletContainer getContainer() {
        return this.container;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pinfo = request.getPathInfo();
        if (pinfo != null && pinfo.startsWith(this.resourcesPrefix)) {
            super.service(request, response);
        } else {
            this.containerService(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void containerService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method;
        if (this.isDirty) {
            this.reloadContainer();
        }
        if (!"GET".equals(method = request.getMethod().toUpperCase())) {
            request.getParameterMap();
        }
        ResourceContext ctx = new ResourceContext(this.app);
        ctx.setRequest(request);
        ResourceContext.setContext(ctx);
        request.setAttribute(ResourceContext.class.getName(), (Object)ctx);
        try {
            this.container.service(request, response);
        }
        finally {
            ResourceContext.destroyContext();
            request.removeAttribute(ResourceContext.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        InputStream in = this.getServletContext().getResourceAsStream(pathInfo.substring(this.resourcesPrefix.length()));
        if (in != null) {
            String ctype = this.getServletContext().getMimeType(pathInfo);
            if (ctype != null) {
                resp.addHeader("Content-Type", ctype);
            }
            try {
                ServletOutputStream out = resp.getOutputStream();
                byte[] bytes = new byte[65536];
                int r = in.read(bytes);
                while (r > -1) {
                    if (r > 0) {
                        out.write(bytes, 0, r);
                    }
                    r = in.read(bytes);
                }
                out.flush();
            }
            finally {
                in.close();
            }
        }
    }

    protected RenderingEngine initRendering(ServletConfig config) throws ServletException {
        try {
            FreemarkerEngine rendering;
            String v = config.getInitParameter(RenderingEngine.class.getName());
            if (v != null) {
                rendering = (RenderingEngine)Utils.getClassRef(v, this.bundle).newInstance();
            } else {
                rendering = new FreemarkerEngine();
                rendering.getConfiguration().setClassicCompatible(false);
            }
            rendering.setResourceLocator((ResourceLocator)this);
            return rendering;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void destroyRendering() {
    }

    protected void initContainer(ServletConfig config) throws ServletException {
        this.container.init(this.getServletConfig());
    }

    protected void destroyContainer() {
        this.container.destroy();
        this.container = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void reloadContainer() throws ServletException {
        try {
            this.container.destroy();
            this.container = this.createServletContainer(this.app);
            this.container.init(this.getServletConfig());
        }
        finally {
            this.isDirty = false;
        }
    }

    protected ServletContainer createServletContainer(ApplicationHost app) {
        ApplicationAdapter adapter = new ApplicationAdapter((Application)app);
        adapter.getFeatures().put("com.sun.jersey.config.feature.DisableWADL", Boolean.TRUE);
        adapter.getFeatures().putAll(app.getFeatures());
        return new ServletContainer((Application)adapter);
    }

    public File getResourceFile(String key) {
        return null;
    }

    public URL getResourceURL(String key) {
        return ResourceContext.getContext().findEntry(key);
    }
}

