/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.concurrent.collector;

import com.phloc.commons.callback.IThrowingRunnableWithParameter;
import com.phloc.commons.concurrent.collector.AbstractConcurrentCollector;
import com.phloc.commons.lang.GenericReflection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentCollectorSingle<DATATYPE>
extends AbstractConcurrentCollector<DATATYPE> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ConcurrentCollectorSingle.class);
    private IThrowingRunnableWithParameter<DATATYPE> m_aPerformer;

    public ConcurrentCollectorSingle() {
        this(null);
    }

    public ConcurrentCollectorSingle(@Nullable IThrowingRunnableWithParameter<DATATYPE> iThrowingRunnableWithParameter) {
        this(100, iThrowingRunnableWithParameter);
    }

    public ConcurrentCollectorSingle(@Nonnegative int n, @Nullable IThrowingRunnableWithParameter<DATATYPE> iThrowingRunnableWithParameter) {
        super(n);
        if (iThrowingRunnableWithParameter != null) {
            this.setPerformer(iThrowingRunnableWithParameter);
        }
    }

    protected final void setPerformer(@Nonnull IThrowingRunnableWithParameter<DATATYPE> iThrowingRunnableWithParameter) {
        if (iThrowingRunnableWithParameter == null) {
            throw new NullPointerException("performer");
        }
        this.m_aPerformer = iThrowingRunnableWithParameter;
    }

    private void _executeCallback(DATATYPE DATATYPE) {
        try {
            this.m_aPerformer.run(DATATYPE);
        }
        catch (Throwable throwable) {
            s_aLogger.error("Failed to perform actions on object - object has been lost!", throwable);
        }
    }

    @Override
    public final void run() {
        if (this.m_aPerformer == null) {
            throw new IllegalStateException("No performer set!");
        }
        try {
            Object e;
            while ((e = this.m_aQueue.take()) != STOP_QUEUE_OBJECT) {
                this._executeCallback(GenericReflection.uncheckedCast(e));
            }
        }
        catch (Throwable throwable) {
            s_aLogger.error("Error taking elements from queue - queue has been interrupted!!!", throwable);
        }
    }
}

