/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.log;

import com.phloc.commons.IHasSize;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.error.EErrorLevel;
import com.phloc.commons.error.IHasErrorLevels;
import com.phloc.commons.log.LogMessage;
import com.phloc.commons.state.EChange;
import com.phloc.commons.state.IClearable;
import com.phloc.commons.string.ToStringGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class InMemoryLogger
implements Iterable<LogMessage>,
IHasSize,
IClearable,
IHasErrorLevels {
    private final List<LogMessage> m_aMessages = new ArrayList<LogMessage>();

    public void log(@Nonnull EErrorLevel eErrorLevel, @Nonnull Object object) {
        this.log(eErrorLevel, object, null);
    }

    public void log(@Nonnull EErrorLevel eErrorLevel, @Nonnull Object object, @Nullable Throwable throwable) {
        this.m_aMessages.add(new LogMessage(eErrorLevel, object, throwable));
    }

    public void error(@Nonnull Object object) {
        this.error(object, null);
    }

    public void error(@Nonnull Object object, @Nullable Throwable throwable) {
        this.log(EErrorLevel.ERROR, object, throwable);
    }

    public void warn(@Nonnull Object object) {
        this.warn(object, null);
    }

    public void warn(@Nonnull Object object, @Nullable Throwable throwable) {
        this.log(EErrorLevel.WARN, object, throwable);
    }

    public void info(@Nonnull Object object) {
        this.log(EErrorLevel.INFO, object, null);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<LogMessage> getAllMessages() {
        return ContainerHelper.newList(this.m_aMessages);
    }

    @Override
    @Nonnull
    public Iterator<LogMessage> iterator() {
        return this.m_aMessages.iterator();
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aMessages.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aMessages.isEmpty();
    }

    @Override
    public boolean containsOnlySuccess() {
        if (this.m_aMessages.isEmpty()) {
            return false;
        }
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isFailure()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneSuccess() {
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isSuccess()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnegative
    public int getSuccessCount() {
        int n = 0;
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isSuccess()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean containsOnlyFailure() {
        if (this.m_aMessages.isEmpty()) {
            return false;
        }
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isSuccess()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneFailure() {
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isFailure()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnegative
    public int getFailureCount() {
        int n = 0;
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isFailure()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean containsOnlyError() {
        if (this.m_aMessages.isEmpty()) {
            return false;
        }
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isNoError()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneError() {
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isError()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnegative
    public int getErrorCount() {
        int n = 0;
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isError()) continue;
            ++n;
        }
        return n;
    }

    @Override
    @Nonnull
    public EChange clear() {
        if (this.m_aMessages.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aMessages.clear();
        return EChange.CHANGED;
    }

    public String toString() {
        return new ToStringGenerator(this).append("messages", this.m_aMessages).toString();
    }
}

