/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.url;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.lang.ServiceLoaderBackport;
import com.phloc.commons.url.EURLProtocol;
import com.phloc.commons.url.IURLData;
import com.phloc.commons.url.IURLProtocol;
import com.phloc.commons.url.IURLProtocolRegistrarSPI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class URLProtocolRegistry {
    private static final Logger s_aLogger = LoggerFactory.getLogger(URLProtocolRegistry.class);
    private static final ReentrantReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Map<String, IURLProtocol> s_aProtocols = new HashMap<String, IURLProtocol>();

    private URLProtocolRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reinitialize() {
        s_aRWLock.writeLock().lock();
        try {
            s_aProtocols.clear();
            for (EURLProtocol eURLProtocol : EURLProtocol.values()) {
                s_aProtocols.put(eURLProtocol.getProtocol(), eURLProtocol);
            }
            for (IURLProtocolRegistrarSPI iURLProtocolRegistrarSPI : ServiceLoaderBackport.load(IURLProtocolRegistrarSPI.class)) {
                s_aLogger.info("Registering custom URL protocols of " + iURLProtocolRegistrarSPI.getClass().getCanonicalName() + "...");
                Set<? extends IURLProtocol> set = iURLProtocolRegistrarSPI.getProtocols();
                if (set == null) continue;
                for (IURLProtocol iURLProtocol : set) {
                    URLProtocolRegistry.registerProtocol(iURLProtocol);
                }
            }
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerProtocol(@Nonnull IURLProtocol iURLProtocol) {
        if (iURLProtocol == null) {
            throw new NullPointerException("protocol");
        }
        s_aRWLock.writeLock().lock();
        try {
            String string = iURLProtocol.getProtocol();
            if (s_aProtocols.containsKey(string)) {
                throw new IllegalArgumentException("Another handler for protocol '" + string + "' is already registered!");
            }
            s_aProtocols.put(string, iURLProtocol);
            s_aLogger.info("Registered new custom URL protocol: " + iURLProtocol);
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Collection<IURLProtocol> getAllProtocols() {
        s_aRWLock.readLock().lock();
        try {
            List<IURLProtocol> list = ContainerHelper.newList(s_aProtocols.values());
            return list;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IURLProtocol getProtocol(@Nullable String string) {
        if (string != null) {
            s_aRWLock.readLock().lock();
            try {
                for (IURLProtocol iURLProtocol : s_aProtocols.values()) {
                    if (!iURLProtocol.isUsedInURL(string)) continue;
                    IURLProtocol iURLProtocol2 = iURLProtocol;
                    return iURLProtocol2;
                }
            }
            finally {
                s_aRWLock.readLock().unlock();
            }
        }
        return null;
    }

    @Nullable
    public static IURLProtocol getProtocol(@Nullable IURLData iURLData) {
        return iURLData == null ? null : URLProtocolRegistry.getProtocol(iURLData.getPath());
    }

    public static boolean hasKnownProtocol(@Nullable String string) {
        return URLProtocolRegistry.getProtocol(string) != null;
    }

    public static boolean hasKnownProtocol(@Nullable IURLData iURLData) {
        return URLProtocolRegistry.getProtocol(iURLData) != null;
    }

    @Nullable
    public static String getWithoutProtocol(@Nullable String string) {
        IURLProtocol iURLProtocol = URLProtocolRegistry.getProtocol(string);
        return iURLProtocol == null ? string : string.substring(iURLProtocol.getProtocol().length());
    }

    static {
        URLProtocolRegistry.reinitialize();
    }
}

