/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.serialize;

import com.phloc.commons.ICloneable;
import com.phloc.commons.charset.CCharset;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.EXMLIncorrectCharacterHandling;
import com.phloc.commons.xml.EXMLVersion;
import com.phloc.commons.xml.serialize.EXMLSerializeComments;
import com.phloc.commons.xml.serialize.EXMLSerializeDocType;
import com.phloc.commons.xml.serialize.EXMLSerializeFormat;
import com.phloc.commons.xml.serialize.EXMLSerializeIndent;
import com.phloc.commons.xml.serialize.IXMLWriterSettings;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.NamespaceContext;

@NotThreadSafe
public final class XMLWriterSettings
implements IXMLWriterSettings,
ICloneable<XMLWriterSettings> {
    public static final String DEFAULT_XML_CHARSET = "UTF-8";
    public static final Charset DEFAULT_XML_CHARSET_OBJ = CCharset.CHARSET_UTF_8_OBJ;
    public static final boolean DEFAULT_USE_DOUBLE_QUOTES_FOR_ATTRIBUTES = true;
    public static final boolean DEFAULT_SPACE_ON_SELF_CLOSED_ELEMENT = true;
    public static final IXMLWriterSettings DEFAULT_XML_SETTINGS = new XMLWriterSettings();
    private EXMLSerializeFormat m_eFormat = EXMLSerializeFormat.XML;
    private EXMLVersion m_eXMLVersion = EXMLVersion.XML_10;
    private EXMLSerializeDocType m_eSerializeDocType = EXMLSerializeDocType.EMIT;
    private EXMLSerializeComments m_eSerializeComments = EXMLSerializeComments.EMIT;
    private EXMLSerializeIndent m_eIndent = EXMLSerializeIndent.INDENT_AND_ALIGN;
    private EXMLIncorrectCharacterHandling m_eIncorrectCharacterHandling = EXMLIncorrectCharacterHandling.DO_NOT_WRITE_LOG_WARNING;
    private Charset m_aCharset = DEFAULT_XML_CHARSET_OBJ;
    private NamespaceContext m_aNamespaceContext;
    private boolean m_bUseDoubleQuotesForAttributes = true;
    private boolean m_bSpaceOnSelfClosedElement = true;

    public XMLWriterSettings() {
    }

    public XMLWriterSettings(@Nonnull IXMLWriterSettings iXMLWriterSettings) {
        if (iXMLWriterSettings == null) {
            throw new NullPointerException("other");
        }
        this.setFormat(iXMLWriterSettings.getFormat());
        this.setXMLVersion(iXMLWriterSettings.getXMLVersion());
        this.setSerializeDocType(iXMLWriterSettings.getSerializeDocType());
        this.setSerializeComments(iXMLWriterSettings.getSerializeComments());
        this.setIndent(iXMLWriterSettings.getIndent());
        this.setIncorrectCharacterHandling(iXMLWriterSettings.getIncorrectCharacterHandling());
        this.setCharset(iXMLWriterSettings.getCharsetObj());
        this.setNamespaceContext(iXMLWriterSettings.getNamespaceContext());
        this.setUseDoubleQuotesForAttributes(iXMLWriterSettings.isUseDoubleQuotesForAttributes());
        this.setSpaceOnSelfClosedElement(iXMLWriterSettings.isSpaceOnSelfClosedElement());
    }

    @Nonnull
    public XMLWriterSettings setFormat(@Nonnull EXMLSerializeFormat eXMLSerializeFormat) {
        if (eXMLSerializeFormat == null) {
            throw new NullPointerException("format");
        }
        this.m_eFormat = eXMLSerializeFormat;
        return this;
    }

    @Override
    @Nonnull
    public EXMLSerializeFormat getFormat() {
        return this.m_eFormat;
    }

    @Nonnull
    public XMLWriterSettings setXMLVersion(@Nonnull EXMLVersion eXMLVersion) {
        if (eXMLVersion == null) {
            throw new NullPointerException("version");
        }
        this.m_eXMLVersion = eXMLVersion;
        return this;
    }

    @Override
    @Nonnull
    public EXMLVersion getXMLVersion() {
        return this.m_eXMLVersion;
    }

    @Nonnull
    public XMLWriterSettings setSerializeDocType(@Nonnull EXMLSerializeDocType eXMLSerializeDocType) {
        if (eXMLSerializeDocType == null) {
            throw new NullPointerException("serializeDocType");
        }
        this.m_eSerializeDocType = eXMLSerializeDocType;
        return this;
    }

    @Override
    @Nonnull
    public EXMLSerializeDocType getSerializeDocType() {
        return this.m_eSerializeDocType;
    }

    @Nonnull
    public XMLWriterSettings setSerializeComments(@Nonnull EXMLSerializeComments eXMLSerializeComments) {
        if (eXMLSerializeComments == null) {
            throw new NullPointerException("serializeComments");
        }
        this.m_eSerializeComments = eXMLSerializeComments;
        return this;
    }

    @Override
    @Nonnull
    public EXMLSerializeComments getSerializeComments() {
        return this.m_eSerializeComments;
    }

    @Nonnull
    public XMLWriterSettings setIndent(@Nonnull EXMLSerializeIndent eXMLSerializeIndent) {
        if (eXMLSerializeIndent == null) {
            throw new NullPointerException("indent");
        }
        this.m_eIndent = eXMLSerializeIndent;
        return this;
    }

    @Override
    @Nonnull
    public EXMLSerializeIndent getIndent() {
        return this.m_eIndent;
    }

    @Nonnull
    public XMLWriterSettings setIncorrectCharacterHandling(@Nonnull EXMLIncorrectCharacterHandling eXMLIncorrectCharacterHandling) {
        if (eXMLIncorrectCharacterHandling == null) {
            throw new NullPointerException("inccorectCharacterHandling");
        }
        this.m_eIncorrectCharacterHandling = eXMLIncorrectCharacterHandling;
        return this;
    }

    @Override
    @Nonnull
    public EXMLIncorrectCharacterHandling getIncorrectCharacterHandling() {
        return this.m_eIncorrectCharacterHandling;
    }

    @Nonnull
    public XMLWriterSettings setCharset(@Nonnull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.m_aCharset = charset;
        return this;
    }

    @Nonnull
    public XMLWriterSettings setCharset(@Nonnull String string) {
        return this.setCharset(CharsetManager.getCharsetFromName(string));
    }

    @Override
    @Nonnull
    public String getCharset() {
        return this.m_aCharset.name();
    }

    @Override
    @Nonnull
    public Charset getCharsetObj() {
        return this.m_aCharset;
    }

    @Nonnull
    public XMLWriterSettings setNamespaceContext(@Nullable NamespaceContext namespaceContext) {
        this.m_aNamespaceContext = namespaceContext;
        return this;
    }

    @Override
    @Nullable
    public NamespaceContext getNamespaceContext() {
        return this.m_aNamespaceContext;
    }

    @Nonnull
    public XMLWriterSettings setUseDoubleQuotesForAttributes(boolean bl) {
        this.m_bUseDoubleQuotesForAttributes = bl;
        return this;
    }

    @Override
    public boolean isUseDoubleQuotesForAttributes() {
        return this.m_bUseDoubleQuotesForAttributes;
    }

    @Nonnull
    public XMLWriterSettings setSpaceOnSelfClosedElement(boolean bl) {
        this.m_bSpaceOnSelfClosedElement = bl;
        return this;
    }

    @Override
    public boolean isSpaceOnSelfClosedElement() {
        return this.m_bSpaceOnSelfClosedElement;
    }

    @Override
    @Nonnull
    public XMLWriterSettings getClone() {
        return new XMLWriterSettings(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XMLWriterSettings)) {
            return false;
        }
        XMLWriterSettings xMLWriterSettings = (XMLWriterSettings)object;
        return this.m_eFormat.equals(xMLWriterSettings.m_eFormat) && this.m_eXMLVersion.equals((Object)xMLWriterSettings.m_eXMLVersion) && this.m_eSerializeDocType.equals(xMLWriterSettings.m_eSerializeDocType) && this.m_eSerializeComments.equals(xMLWriterSettings.m_eSerializeComments) && this.m_eIndent.equals(xMLWriterSettings.m_eIndent) && this.m_eIncorrectCharacterHandling.equals((Object)xMLWriterSettings.m_eIncorrectCharacterHandling) && this.m_aCharset.equals(xMLWriterSettings.m_aCharset) && this.m_bUseDoubleQuotesForAttributes == xMLWriterSettings.m_bUseDoubleQuotesForAttributes && this.m_bSpaceOnSelfClosedElement == xMLWriterSettings.m_bSpaceOnSelfClosedElement;
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eFormat)).append((Enum)this.m_eXMLVersion)).append((Enum)this.m_eSerializeDocType)).append((Enum)this.m_eSerializeComments)).append((Enum)this.m_eIndent)).append((Enum)this.m_eIncorrectCharacterHandling)).append(this.m_aCharset).append(this.m_bUseDoubleQuotesForAttributes).append(this.m_bSpaceOnSelfClosedElement).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("format", this.m_eFormat).append("xmlVersion", this.m_eXMLVersion).append("serializeDocType", this.m_eSerializeDocType).append("serializeComments", this.m_eSerializeComments).append("indent", this.m_eIndent).append("incorrectCharHandling", this.m_eIncorrectCharacterHandling).append("charset", this.m_aCharset).append("namespaceContext", this.m_aNamespaceContext).append("doubleQuotesForAttrs", this.m_bUseDoubleQuotesForAttributes).append("spaceOnSelfClosedElement", this.m_bSpaceOnSelfClosedElement).toString();
    }
}

