/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.FloatCollection;
import org.apache.commons.collections.primitives.FloatIterator;
import org.apache.commons.collections.primitives.RandomAccessFloatList;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class ArrayFloatList
extends RandomAccessFloatList
implements Serializable {
    private transient float[] _data;
    private int _size;

    public ArrayFloatList() {
        this(8);
    }

    public ArrayFloatList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity " + n);
        }
        this._data = new float[n];
        this._size = 0;
    }

    public ArrayFloatList(@Nonnull FloatCollection floatCollection) {
        this(floatCollection.size());
        this.addAll(floatCollection);
    }

    public ArrayFloatList(@Nonnull float[] fArray) {
        this(fArray.length);
        System.arraycopy(fArray, 0, this._data, 0, fArray.length);
        this._size = fArray.length;
    }

    @Override
    public float get(int n) {
        this._checkRange(n);
        return this._data[n];
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public float removeElementAt(int n) {
        this._checkRange(n);
        this.incrModCount();
        float f = this._data[n];
        int n2 = this._size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this._data, n + 1, this._data, n, n2);
        }
        --this._size;
        return f;
    }

    @Override
    public float set(int n, float f) {
        this._checkRange(n);
        this.incrModCount();
        float f2 = this._data[n];
        this._data[n] = f;
        return f2;
    }

    @Override
    public void add(int n, float f) {
        this._checkRangeIncludingEndpoint(n);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int n2 = this._size - n;
        System.arraycopy(this._data, n, this._data, n + 1, n2);
        this._data[n] = f;
        ++this._size;
    }

    @Override
    public void clear() {
        this.incrModCount();
        this._size = 0;
    }

    @Override
    public boolean addAll(@Nonnull FloatCollection floatCollection) {
        return this.addAll(this.size(), floatCollection);
    }

    @Override
    public boolean addAll(int n, @Nonnull FloatCollection floatCollection) {
        if (floatCollection.size() == 0) {
            return false;
        }
        int n2 = n;
        this._checkRangeIncludingEndpoint(n2);
        this.incrModCount();
        this.ensureCapacity(this._size + floatCollection.size());
        if (n2 != this._size) {
            System.arraycopy(this._data, n2, this._data, n2 + floatCollection.size(), this._size - n2);
        }
        FloatIterator floatIterator = floatCollection.iterator();
        while (floatIterator.hasNext()) {
            this._data[n2] = floatIterator.next();
            ++n2;
        }
        this._size += floatCollection.size();
        return true;
    }

    public void ensureCapacity(int n) {
        this.incrModCount();
        if (n > this._data.length) {
            int n2 = this._data.length * 3 / 2 + 1;
            float[] fArray = this._data;
            this._data = new float[n2 < n ? n : n2];
            System.arraycopy(fArray, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            float[] fArray = this._data;
            this._data = new float[this._size];
            System.arraycopy(fArray, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            objectOutputStream.writeFloat(this._data[i]);
        }
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._data = new float[objectInputStream.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = objectInputStream.readFloat();
        }
    }

    private final void _checkRange(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + n);
        }
    }

    private final void _checkRangeIncludingEndpoint(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + n);
        }
    }
}

