/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.ShortCollection;
import org.apache.commons.collections.primitives.adapters.AbstractShortCollectionCollection;
import org.apache.commons.collections.primitives.adapters.NonSerializableShortCollectionCollection;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public final class ShortCollectionCollection
extends AbstractShortCollectionCollection
implements Serializable {
    private transient ShortCollection m_aCollection;

    public ShortCollectionCollection(@Nonnull ShortCollection shortCollection) {
        this.m_aCollection = shortCollection;
    }

    @Override
    @Nonnull
    protected ShortCollection getShortCollection() {
        return this.m_aCollection;
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.m_aCollection);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_aCollection = (ShortCollection)objectInputStream.readObject();
    }

    @Nullable
    public static Collection<Short> wrap(@Nullable ShortCollection shortCollection) {
        if (null == shortCollection) {
            return null;
        }
        if (shortCollection instanceof Serializable) {
            return new ShortCollectionCollection(shortCollection);
        }
        return new NonSerializableShortCollectionCollection(shortCollection);
    }
}

