/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.suggestbox.service.Suggester;
import org.nuxeo.ecm.platform.suggestbox.service.Suggestion;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionContext;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionException;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionService;
import org.nuxeo.ecm.platform.suggestbox.service.descriptors.SuggesterDescriptor;
import org.nuxeo.ecm.platform.suggestbox.service.descriptors.SuggesterGroupDescriptor;
import org.nuxeo.ecm.platform.suggestbox.service.descriptors.SuggesterGroupItemDescriptor;
import org.nuxeo.ecm.platform.suggestbox.service.registries.SuggesterGroupRegistry;
import org.nuxeo.ecm.platform.suggestbox.service.registries.SuggesterRegistry;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class SuggestionServiceImpl
extends DefaultComponent
implements SuggestionService {
    private static final Log log = LogFactory.getLog(SuggestionServiceImpl.class);
    protected SuggesterGroupRegistry suggesterGroups;
    protected SuggesterRegistry suggesters;

    @Override
    public List<Suggestion> suggest(String userInput, SuggestionContext context) throws SuggestionException {
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        SuggesterGroupDescriptor suggesterGroup = this.suggesterGroups.getSuggesterGroupDescriptor(context.suggesterGroup);
        if (suggesterGroup == null) {
            log.warn((Object)("No registered SuggesterGroup with id: " + context.suggesterGroup));
            return suggestions;
        }
        for (SuggesterGroupItemDescriptor suggesterGroupItem : suggesterGroup.getSuggesters()) {
            String suggesterId = suggesterGroupItem.getName();
            SuggesterDescriptor suggesterDescritor = this.suggesters.getSuggesterDescriptor(suggesterId);
            if (suggesterDescritor == null) {
                log.warn((Object)("No suggester registered with id: " + suggesterId));
                continue;
            }
            if (!suggesterDescritor.isEnabled()) continue;
            Suggester suggester = suggesterDescritor.getSuggester();
            if (suggester == null) {
                log.warn((Object)("Suggester with id '" + suggesterId + "' has a configuration that prevents instanciation" + " (no className in aggregate descriptor)"));
                continue;
            }
            suggestions.addAll(suggester.suggest(userInput, context));
        }
        return suggestions;
    }

    @Override
    public List<Suggestion> suggest(String input, SuggestionContext context, String suggesterName) throws SuggestionException {
        SuggesterDescriptor suggesterDescriptor = this.suggesters.getSuggesterDescriptor(suggesterName);
        if (suggesterDescriptor == null) {
            throw new SuggestionException(String.format("No suggester registered under the name '%s'.", suggesterName));
        }
        if (!suggesterDescriptor.isEnabled()) {
            throw new SuggestionException(String.format("Suggester registered under the name '%s' is disabled.", suggesterName));
        }
        Suggester suggester = suggesterDescriptor.getSuggester();
        if (suggester == null) {
            String message = "Suggester with id '" + suggesterName + "' has a configuration that prevents instanciation" + " (no className in aggregate descriptor)";
            throw new SuggestionException(message);
        }
        return suggester.suggest(input, context);
    }

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.suggesters = new SuggesterRegistry();
        this.suggesterGroups = new SuggesterGroupRegistry();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (contribution instanceof SuggesterDescriptor) {
            SuggesterDescriptor suggesterDescriptor = (SuggesterDescriptor)contribution;
            log.info((Object)String.format("Registering suggester '%s'", suggesterDescriptor.getName()));
            suggesterDescriptor.setRuntimeContext(contributor.getRuntimeContext());
            this.suggesters.addContribution(suggesterDescriptor);
        } else if (contribution instanceof SuggesterGroupDescriptor) {
            SuggesterGroupDescriptor suggesterGroupDescriptor = (SuggesterGroupDescriptor)contribution;
            log.info((Object)String.format("Registering suggester group '%s'", suggesterGroupDescriptor.getName()));
            this.suggesterGroups.addContribution(suggesterGroupDescriptor);
        } else {
            log.error((Object)String.format("Unknown contribution to the SuggestionService styling service, extension point '%s': '%s", extensionPoint, contribution));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (contribution instanceof SuggesterDescriptor) {
            SuggesterDescriptor suggesterDescriptor = (SuggesterDescriptor)contribution;
            log.info((Object)String.format("Unregistering suggester '%s'", suggesterDescriptor.getName()));
            this.suggesters.removeContribution(suggesterDescriptor);
        } else if (contribution instanceof SuggesterGroupDescriptor) {
            SuggesterGroupDescriptor suggesterGroupDescriptor = (SuggesterGroupDescriptor)contribution;
            log.info((Object)String.format("Unregistering suggester group '%s'", suggesterGroupDescriptor.getName()));
            this.suggesterGroups.removeContribution(suggesterGroupDescriptor);
        } else {
            log.error((Object)String.format("Unknown contribution to the SuggestionService styling service, extension point '%s': '%s", extensionPoint, contribution));
        }
    }

    public SuggesterGroupRegistry getSuggesterGroups() {
        return this.suggesterGroups;
    }
}

