/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.blob;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.DefaultBlob;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.ByteArraySource;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.InputStreamSource;
import org.nuxeo.runtime.services.streaming.StreamSource;
import org.nuxeo.runtime.services.streaming.StringSource;
import org.nuxeo.runtime.services.streaming.URLSource;

public class StreamingBlob
extends DefaultBlob
implements Serializable {
    public static final int MEM_MAX_LIMIT = 0x100000;
    private static final long serialVersionUID = 8275917049427979525L;
    protected transient StreamSource src;
    protected transient File persistedTmpFile;

    public StreamingBlob(StreamSource src) {
        this(src, null, null);
    }

    public StreamingBlob(StreamSource src, String mimeType) {
        this(src, mimeType, null);
    }

    public StreamingBlob(StreamSource src, String mimeType, String encoding) {
        this(src, mimeType, encoding, null, null);
    }

    public StreamingBlob(StreamSource src, String mimeType, String encoding, String filename, String digest) {
        this.src = src;
        this.mimeType = mimeType;
        this.encoding = encoding;
        this.filename = filename;
        this.digest = digest;
    }

    public static StreamingBlob createFromStream(InputStream is) {
        return StreamingBlob.createFromStream(is, null);
    }

    public static StreamingBlob createFromStream(InputStream is, String mimeType) {
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        InputStreamSource src = new InputStreamSource(is);
        return new StreamingBlob((StreamSource)src, mimeType);
    }

    public static StreamingBlob createFromByteArray(byte[] bytes) {
        return StreamingBlob.createFromByteArray(bytes, null);
    }

    public static StreamingBlob createFromByteArray(byte[] bytes, String mimeType) {
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        ByteArraySource src = new ByteArraySource(bytes);
        return new StreamingBlob((StreamSource)src, mimeType);
    }

    public static StreamingBlob createFromString(String str) {
        return StreamingBlob.createFromString(str, null);
    }

    public static StreamingBlob createFromString(String str, String mimeType) {
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        StringSource src = new StringSource(str);
        return new StreamingBlob((StreamSource)src, mimeType);
    }

    public static StreamingBlob createFromFile(File file) {
        return StreamingBlob.createFromFile(file, null);
    }

    public static StreamingBlob createFromFile(File file, String mimeType) {
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        FileSource src = new FileSource(file);
        return new StreamingBlob((StreamSource)src, mimeType);
    }

    public static StreamingBlob createFromURL(URL url) {
        return StreamingBlob.createFromURL(url, null);
    }

    public static StreamingBlob createFromURL(URL url, String mimeType) {
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        URLSource src = new URLSource(url);
        return new StreamingBlob((StreamSource)src, mimeType);
    }

    @Override
    public byte[] getByteArray() throws IOException {
        return this.src.getBytes();
    }

    @Override
    public long getLength() {
        try {
            return this.src.getLength();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Override
    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getStream());
    }

    @Override
    public InputStream getStream() throws IOException {
        return this.src.getStream();
    }

    @Override
    public String getString() throws IOException {
        return this.src.getString();
    }

    @Override
    public boolean isPersistent() {
        return this.src.canReopen();
    }

    public StreamSource getStreamSource() {
        return this.src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob persist() throws IOException {
        if (!this.isPersistent()) {
            FileOutputStream out = null;
            InputStream in = null;
            try {
                this.persistedTmpFile = File.createTempFile("NXCore-persisted-StreamingBlob-", ".tmp");
                in = this.src.getStream();
                out = new FileOutputStream(this.persistedTmpFile);
                StreamingBlob.copy(in, out);
                this.src = new FileSource(this.persistedTmpFile);
                Framework.trackFile((File)this.persistedTmpFile, (Object)this);
            }
            catch (Throwable throwable) {
                FileUtils.close(in);
                FileUtils.close(out);
                throw throwable;
            }
            FileUtils.close((InputStream)in);
            FileUtils.close((OutputStream)out);
        }
        return this;
    }

    public boolean isTemporary() {
        return this.persistedTmpFile != null;
    }
}

