/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.PropertyRuntimeException;

public class DirtyPropertyIterator
implements Iterator<Property> {
    private final Iterator<Property> it;
    private Property property;
    private Property next;

    public DirtyPropertyIterator(Iterator<Property> it) {
        this.it = it;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        while (this.it.hasNext()) {
            this.next = this.it.next();
            if (!this.next.isDirty()) continue;
            return true;
        }
        this.next = null;
        return false;
    }

    @Override
    public Property next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements to iterate over");
        }
        this.property = this.next;
        this.next = null;
        return this.property;
    }

    @Override
    public void remove() {
        if (this.property == null) {
            throw new IllegalStateException("Cannot call remove on a non initialized iterator");
        }
        try {
            this.property.remove();
        }
        catch (PropertyException e) {
            throw new PropertyRuntimeException("Failed to remove property", e);
        }
    }
}

