/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.pathsegment;

import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentServiceDefault;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentServiceDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class PathSegmentComponent
extends DefaultComponent
implements PathSegmentService {
    private static final Log log = LogFactory.getLog(PathSegmentComponent.class);
    public static final String XP = "pathSegmentService";
    protected LinkedList<Class<? extends PathSegmentService>> contribs;
    protected PathSegmentService service;
    protected boolean recompute;

    public void activate(ComponentContext context) throws Exception {
        this.contribs = new LinkedList();
        this.recompute = true;
        this.service = null;
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.contribs.clear();
        this.service = null;
    }

    public void registerContribution(Object contrib, String xp, ComponentInstance contributor) throws Exception {
        Class<?> klass;
        if (!XP.equals(xp)) {
            log.error((Object)("Unknown extension point " + xp));
            return;
        }
        if (!(contrib instanceof PathSegmentServiceDescriptor)) {
            log.error((Object)("Invalid contribution: " + contrib.getClass().getName()));
            return;
        }
        PathSegmentServiceDescriptor desc = (PathSegmentServiceDescriptor)contrib;
        try {
            klass = Class.forName(desc.className);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Invalid contribution class: " + desc.className));
            return;
        }
        if (!PathSegmentService.class.isAssignableFrom(klass)) {
            log.error((Object)("Invalid contribution class: " + desc.className));
            return;
        }
        this.contribs.add(klass);
        log.info((Object)("Registered path segment service: " + desc.className));
        this.recompute = true;
    }

    public void unregisterContribution(Object contrib, String xp, ComponentInstance contributor) throws Exception {
        Class<PathSegmentService> klass;
        if (!XP.equals(xp)) {
            return;
        }
        if (!(contrib instanceof PathSegmentServiceDescriptor)) {
            return;
        }
        PathSegmentServiceDescriptor desc = (PathSegmentServiceDescriptor)contrib;
        try {
            klass = Class.forName(desc.className);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        if (!klass.isAssignableFrom(PathSegmentService.class)) {
            return;
        }
        this.contribs.remove(klass);
        log.info((Object)("Unregistered path segment service: " + desc.className));
        this.recompute = true;
    }

    @Override
    public String generatePathSegment(DocumentModel doc) throws ClientException {
        if (this.recompute) {
            this.recompute();
            this.recompute = false;
        }
        return this.service.generatePathSegment(doc);
    }

    protected void recompute() throws ClientException {
        Class klass = this.contribs.isEmpty() ? PathSegmentServiceDefault.class : this.contribs.getLast();
        if (this.service == null || klass != this.service.getClass()) {
            try {
                this.service = (PathSegmentService)klass.newInstance();
            }
            catch (Exception e) {
                throw new ClientException(e);
            }
        }
    }

    @Override
    public String generatePathSegment(String s) throws ClientException {
        if (this.recompute) {
            this.recompute();
            this.recompute = false;
        }
        return this.service.generatePathSegment(s);
    }
}

