/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.fst;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.search.suggest.Sort;
import org.apache.lucene.search.suggest.fst.BytesRefSorter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.IOUtils;

public class ExternalRefSorter
implements BytesRefSorter,
Closeable {
    private final Sort sort;
    private Sort.ByteSequencesWriter writer;
    private File input;
    private File sorted;

    public ExternalRefSorter(Sort sort) throws IOException {
        this.sort = sort;
        this.input = File.createTempFile("RefSorter-", ".raw", Sort.defaultTempDir());
        this.writer = new Sort.ByteSequencesWriter(this.input);
    }

    @Override
    public void add(BytesRef utf8) throws IOException {
        if (this.writer == null) {
            throw new IllegalStateException();
        }
        this.writer.write(utf8);
    }

    @Override
    public BytesRefIterator iterator() throws IOException {
        if (this.sorted == null) {
            this.closeWriter();
            this.sorted = File.createTempFile("RefSorter-", ".sorted", Sort.defaultTempDir());
            this.sort.sort(this.input, this.sorted);
            this.input.delete();
            this.input = null;
        }
        return new ByteSequenceIterator(new Sort.ByteSequencesReader(this.sorted), this.sort.getComparator());
    }

    private void closeWriter() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.closeWriter();
        }
        finally {
            if (this.input != null) {
                this.input.delete();
            }
            if (this.sorted != null) {
                this.sorted.delete();
            }
        }
    }

    @Override
    public Comparator<BytesRef> getComparator() {
        return this.sort.getComparator();
    }

    class ByteSequenceIterator
    implements BytesRefIterator {
        private final Sort.ByteSequencesReader reader;
        private BytesRef scratch = new BytesRef();
        private final Comparator<BytesRef> comparator;

        public ByteSequenceIterator(Sort.ByteSequencesReader reader, Comparator<BytesRef> comparator) {
            this.reader = reader;
            this.comparator = comparator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BytesRef next() throws IOException {
            BytesRef bytesRef;
            block6: {
                if (this.scratch == null) {
                    return null;
                }
                boolean success = false;
                try {
                    byte[] next = this.reader.read();
                    if (next != null) {
                        this.scratch.bytes = next;
                        this.scratch.length = next.length;
                        this.scratch.offset = 0;
                    } else {
                        IOUtils.close((Closeable[])new Closeable[]{this.reader});
                        this.scratch = null;
                    }
                    success = true;
                    bytesRef = this.scratch;
                    if (success) break block6;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.reader});
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.reader});
            }
            return bytesRef;
        }

        public Comparator<BytesRef> getComparator() {
            return this.comparator;
        }
    }
}

