/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ListDiff;
import org.nuxeo.ecm.platform.ui.web.model.EditableModel;
import org.nuxeo.ecm.platform.ui.web.util.DeepCopy;

public class EditableModelImpl
extends DataModel
implements EditableModel,
Serializable {
    private static final long serialVersionUID = 2550850486035521538L;
    private static final Log log = LogFactory.getLog(EditableModelImpl.class);
    private static final Object _NULL = new Object();
    protected final Object originalData;
    protected List data;
    protected int index = -1;
    protected Map<Integer, Integer> keyMap;
    protected ListDiff listDiff;

    public EditableModelImpl(Object value) {
        if (value != null && !(value instanceof List) && !(value instanceof Object[])) {
            log.error((Object)("Cannot build editable model from " + value + ", list or array needed"));
            value = null;
        }
        this.originalData = value;
        this.listDiff = new ListDiff();
        this.keyMap = new HashMap<Integer, Integer>();
        this.initializeData(value);
    }

    protected void initializeData(Object originalData) {
        List<Object> data = null;
        if (originalData == null) {
            data = new ArrayList();
        } else if (originalData instanceof Object[]) {
            data = new ArrayList();
            for (Object item : (Object[])originalData) {
                data.add(DeepCopy.deepCopy(item));
            }
        } else if (originalData instanceof List) {
            data = (List)DeepCopy.deepCopy(originalData);
        }
        this.setWrappedData(data);
    }

    @Override
    public Object getOriginalData() {
        return this.originalData;
    }

    @Override
    public Object getWrappedData() {
        return this.data;
    }

    @Override
    public void setWrappedData(Object data) {
        if (data == null) {
            this.data = null;
            this.setRowIndex(-1);
        } else {
            this.data = (List)data;
            this.index = -1;
            this.setRowIndex(0);
            for (int i = 0; i < this.data.size(); ++i) {
                this.keyMap.put(i, i);
            }
        }
    }

    protected Object getOriginalRowDataForKey(int key) {
        if (this.originalData instanceof List) {
            List list = (List)this.originalData;
            if (key < 0 || key >= list.size()) {
                return _NULL;
            }
            return list.get(key);
        }
        if (this.originalData instanceof Object[]) {
            Object[] array = (Object[])this.originalData;
            if (key < 0 || key >= array.length) {
                return _NULL;
            }
            return array[key];
        }
        return _NULL;
    }

    protected int getNewRowKey() {
        Collection<Integer> keys = this.keyMap.values();
        if (keys.isEmpty()) {
            return 0;
        }
        List<Integer> lkeys = Arrays.asList(keys.toArray(new Integer[0]));
        Comparator comp = Collections.reverseOrder();
        Collections.sort(lkeys, comp);
        Integer max = lkeys.get(0);
        return max + 1;
    }

    @Override
    public boolean isRowAvailable() {
        if (this.data == null) {
            return false;
        }
        return this.index >= 0 && this.index < this.data.size();
    }

    @Override
    public boolean isRowModified() {
        if (!this.isRowAvailable()) {
            return false;
        }
        Integer rowKey = this.getRowKey();
        if (rowKey == null) {
            return false;
        }
        Object oldData = this.getOriginalRowDataForKey(rowKey);
        if (oldData == _NULL) {
            return false;
        }
        Object newData = this.getRowData();
        if (newData == null && oldData == null) {
            return false;
        }
        if (newData != null) {
            return !newData.equals(oldData);
        }
        return !oldData.equals(newData);
    }

    @Override
    public boolean isRowNew() {
        if (!this.isRowAvailable()) {
            return false;
        }
        Integer rowKey = this.getRowKey();
        if (rowKey == null) {
            return false;
        }
        Object oldData = this.getOriginalRowDataForKey(rowKey);
        return oldData == _NULL;
    }

    @Override
    public void recordValueModified(int index, Object newValue) {
        this.listDiff.modify(index, newValue);
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return -1;
        }
        return this.data.size();
    }

    @Override
    public Object getRowData() {
        if (this.data == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        return this.data.get(this.index);
    }

    @Override
    public void setRowData(Object rowData) {
        if (this.isRowAvailable()) {
            this.data.set(this.index, rowData);
        }
    }

    @Override
    public int getRowIndex() {
        return this.index;
    }

    @Override
    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int old = this.index;
        this.index = rowIndex;
        if (this.data == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (old != this.index && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent((DataModel)this, this.index, rowData);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (null == listeners[i]) continue;
                listeners[i].rowSelected(event);
            }
        }
    }

    @Override
    public Integer getRowKey() {
        if (this.index < 0) {
            return null;
        }
        return this.keyMap.get(this.index);
    }

    @Override
    public void setRowKey(Integer key) {
        if (key != null) {
            for (Integer i : this.keyMap.keySet()) {
                Integer k = this.keyMap.get(i);
                if (!key.equals(k)) continue;
                this.setRowIndex(i);
                break;
            }
        } else {
            this.setRowIndex(-1);
        }
    }

    @Override
    public ListDiff getListDiff() {
        return this.listDiff;
    }

    @Override
    public void setListDiff(ListDiff listDiff) {
        this.listDiff = new ListDiff(listDiff);
    }

    @Override
    public boolean isDirty() {
        return this.listDiff != null && this.listDiff.isDirty();
    }

    @Override
    public boolean addValue(Object value) {
        int position = this.data.size();
        boolean res = this.data.add(value);
        this.listDiff.add(value);
        int newRowKey = this.getNewRowKey();
        this.keyMap.put(position, newRowKey);
        return res;
    }

    @Override
    public void insertValue(int index, Object value) {
        this.data.add(index, value);
        this.listDiff.insert(index, value);
        HashMap<Integer, Integer> newKeyMap = new HashMap<Integer, Integer>();
        for (Integer i : this.keyMap.keySet()) {
            Integer key = this.keyMap.get(i);
            if (i >= index) {
                newKeyMap.put(i + 1, key);
                continue;
            }
            newKeyMap.put(i, key);
        }
        this.keyMap = newKeyMap;
        int newRowKey = this.getNewRowKey();
        this.keyMap.put(index, newRowKey);
    }

    @Override
    public Object moveValue(int fromIndex, int toIndex) {
        Object old = this.data.remove(fromIndex);
        this.data.add(toIndex, old);
        this.listDiff.move(fromIndex, toIndex);
        HashMap<Integer, Integer> newKeyMap = new HashMap<Integer, Integer>();
        if (fromIndex < toIndex) {
            for (Integer i : this.keyMap.keySet()) {
                Integer key = this.keyMap.get(i);
                if (i < fromIndex) {
                    newKeyMap.put(i, key);
                    continue;
                }
                if (i > fromIndex && i <= toIndex) {
                    newKeyMap.put(i - 1, key);
                    continue;
                }
                if (i <= toIndex) continue;
                newKeyMap.put(i, key);
            }
        } else if (fromIndex > toIndex) {
            for (Integer i : this.keyMap.keySet()) {
                Integer key = this.keyMap.get(i);
                if (i < toIndex) {
                    newKeyMap.put(i, key);
                    continue;
                }
                if (i >= toIndex && i < fromIndex) {
                    newKeyMap.put(i + 1, key);
                    continue;
                }
                if (i <= fromIndex) continue;
                newKeyMap.put(i, key);
            }
        }
        newKeyMap.put(toIndex, this.keyMap.get(fromIndex));
        this.keyMap = newKeyMap;
        return old;
    }

    @Override
    public Object removeValue(int index) {
        Object old = this.data.remove(index);
        this.listDiff.remove(index);
        HashMap<Integer, Integer> newKeyMap = new HashMap<Integer, Integer>();
        for (Integer i : this.keyMap.keySet()) {
            Integer key = this.keyMap.get(i);
            if (i > index) {
                newKeyMap.put(i - 1, key);
                continue;
            }
            if (i >= index) continue;
            newKeyMap.put(i, key);
        }
        this.keyMap = newKeyMap;
        return old;
    }

    @Override
    public int size() {
        if (this.data != null) {
            return this.data.size();
        }
        return 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(EditableModelImpl.class.getSimpleName());
        buf.append(" {");
        buf.append("originalData: ");
        buf.append(this.originalData);
        buf.append(", data: ");
        buf.append(this.data);
        buf.append(", index: ");
        buf.append(this.index);
        buf.append(", keyMap: ");
        buf.append(this.keyMap);
        buf.append(", dirty: ");
        buf.append(this.isDirty());
        buf.append('}');
        return buf.toString();
    }
}

