/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.tag.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagException;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.platform.ui.web.binding.MetaValueExpression;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasTagHandler;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasVariableMapper;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;

public class SetTagHandler
extends AliasTagHandler {
    protected final TagAttribute var = this.getRequiredAttribute("var");
    protected final TagAttribute value = this.getAttribute("value");
    protected final TagAttribute resolveTwice = this.getAttribute("resolveTwice");
    protected final TagAttribute blockPatterns = this.getAttribute("blockPatterns");
    protected final TagAttribute blockMerge = this.getAttribute("blockMerge");

    public SetTagHandler(ComponentConfig config) {
        super(config, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (parent == null) {
            throw new TagException(this.tag, "Parent UIComponent was null");
        }
        FaceletHandler nextHandler = this.nextHandler;
        VariableMapper orig = ctx.getVariableMapper();
        AliasVariableMapper target = new AliasVariableMapper();
        target.setId(ctx.generateUniqueId(this.tagId));
        VariableMapper vm = target.getVariableMapperForBuild(orig);
        ctx.setVariableMapper(vm);
        try {
            nextHandler = this.getAliasVariableMapper(ctx, target);
        }
        finally {
            ctx.setVariableMapper(orig);
        }
        this.apply(ctx, parent, target, nextHandler);
    }

    public FaceletHandler getNextHandler() {
        return this.nextHandler;
    }

    public boolean isAcceptingMerge(FaceletContext ctx) {
        String blocked;
        if (this.blockMerge != null && this.blockMerge.getBoolean(ctx)) {
            return false;
        }
        return this.blockPatterns == null || StringUtils.isEmpty((String)(blocked = this.blockPatterns.getValue(ctx)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FaceletHandler getAliasVariableMapper(FaceletContext ctx, AliasVariableMapper target) {
        SetTagHandler next;
        FaceletHandler nextHandler;
        String blockedValue;
        ValueExpression ve;
        String varStr = this.var.getValue(ctx);
        if (target.hasVariables(varStr)) {
            return this.nextHandler;
        }
        boolean cacheValue = false;
        if (this.cache != null) {
            cacheValue = this.cache.getBoolean(ctx);
        }
        boolean resolveTwiceBool = false;
        if (this.resolveTwice != null) {
            resolveTwiceBool = this.resolveTwice.getBoolean(ctx);
        }
        if (cacheValue) {
            Object res = this.value.getObject(ctx);
            if (resolveTwiceBool && res instanceof String && ComponentTagUtils.isValueReference((String)res)) {
                ve = ctx.getExpressionFactory().createValueExpression((ELContext)ctx, (String)res, Object.class);
                res = ve.getValue((ELContext)ctx);
            }
            ve = ctx.getExpressionFactory().createValueExpression(res, Object.class);
        } else {
            ve = this.value.getValueExpression(ctx, Object.class);
            if (resolveTwiceBool) {
                ve = new MetaValueExpression(ve);
            }
        }
        target.setVariable(varStr, ve);
        if (this.blockPatterns != null && !StringUtils.isEmpty((String)(blockedValue = this.blockPatterns.getValue(ctx)))) {
            target.setBlockedPatterns(this.resolveBlockPatterns(blockedValue));
        }
        if ((nextHandler = this.nextHandler) instanceof SetTagHandler && (next = (SetTagHandler)nextHandler).isAcceptingMerge(ctx)) {
            ctx.getVariableMapper().setVariable(varStr, ve);
            try {
                AliasVariableMapper.exposeAliasesToRequest(ctx.getFacesContext(), target);
                nextHandler = next.getAliasVariableMapper(ctx, target);
            }
            finally {
                AliasVariableMapper.removeAliasesExposedToRequest(ctx.getFacesContext(), target.getId());
            }
        }
        return nextHandler;
    }

    protected List<String> resolveBlockPatterns(String value) {
        String[] split;
        ArrayList<String> res = new ArrayList<String>();
        if (value != null && (split = StringUtils.split((String)value, (char)',')) != null) {
            for (String item : split) {
                res.add(item.trim());
            }
        }
        return res;
    }
}

