/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util;

import java.util.Iterator;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;

public class ComponentRenderUtils {
    public static String getComponentAbsoluteId(UIComponent base, String targetId) {
        if (targetId == null || targetId.startsWith(":")) {
            return targetId;
        }
        String id = targetId;
        UIComponent target = ComponentRenderUtils.findComponentFor(base, id);
        if (target != null) {
            id = ComponentRenderUtils.getAbsoluteId(target);
        }
        return id;
    }

    public static UIComponent getComponent(UIComponent base, String targetId) {
        String id = ComponentRenderUtils.getComponentAbsoluteId(base, targetId);
        FacesContext ctx = FacesContext.getCurrentInstance();
        UIComponent anchor = ctx.getViewRoot().findComponent(id);
        return anchor;
    }

    public static UIComponent findComponentFor(UIComponent component, String id) {
        if (id == null) {
            throw new NullPointerException("id is null!");
        }
        if (id.length() == 0) {
            return null;
        }
        UIComponent target = null;
        UIComponent root = component;
        for (UIComponent parent = component; target == null && parent != null; parent = parent.getParent()) {
            target = ComponentRenderUtils.findUIComponentBelow(parent, id);
            root = parent;
        }
        if (target == null) {
            target = ComponentRenderUtils.findUIComponentBelow(root, id);
        }
        return target;
    }

    protected static UIComponent findUIComponentBelow(UIComponent root, String id) {
        UIComponent target = null;
        Iterator iter = root.getFacetsAndChildren();
        while (iter.hasNext()) {
            UIComponent child = (UIComponent)iter.next();
            if (child instanceof NamingContainer) {
                try {
                    target = child.findComponent(id);
                }
                catch (IllegalArgumentException iae) {
                    continue;
                }
            }
            if (target == null && child.getChildCount() > 0) {
                target = ComponentRenderUtils.findUIComponentBelow(child, id);
            }
            if (target == null) continue;
            break;
        }
        return target;
    }

    public static String getAbsoluteId(UIComponent component) {
        StringBuffer idBuf = new StringBuffer();
        idBuf.append(component.getId());
        UIComponent parent = component;
        char sep = UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance());
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof NamingContainer)) continue;
            idBuf.insert(0, sep);
            idBuf.insert(0, parent.getId());
        }
        idBuf.insert(0, sep);
        return idBuf.toString();
    }
}

