/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jaxrs.io.documents;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.automation.jaxrs.io.InputStreamDataSource;
import org.nuxeo.ecm.core.api.Blob;

public class MultipartBlobs
extends MimeMultipart {
    private static final Pattern BOUNDARY = Pattern.compile(";\\s*boundary\\s*=\"([^\"]+)\"");

    public MultipartBlobs() {
        super("mixed");
    }

    public MultipartBlobs(List<Blob> blobs) throws Exception {
        super("mixed");
        this.addBlobs(blobs);
    }

    public void addBlobs(List<Blob> blobs) throws Exception {
        for (Blob blob : blobs) {
            this.addBlob(blob);
        }
    }

    public void addBlob(Blob blob) throws Exception {
        String mimeType;
        MimeBodyPart part = new MimeBodyPart();
        part.setDataHandler(new DataHandler((DataSource)new InputStreamDataSource(blob.getStream(), blob.getMimeType(), blob.getFilename())));
        part.setDisposition("attachment");
        String filename = blob.getFilename();
        if (filename != null) {
            part.setFileName(filename);
        }
        if ((mimeType = blob.getMimeType()) != null) {
            part.setHeader("Content-type", mimeType);
        }
        this.addBodyPart((BodyPart)part);
    }

    public String getBoundary() {
        Matcher m = BOUNDARY.matcher(this.getContentType());
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public Response getResponse() {
        return Response.ok((Object)((Object)this)).type((MediaType)new BoundaryMediaType(this.getContentType())).build();
    }

    static class BoundaryMediaType
    extends MediaType {
        private final String ctype;

        BoundaryMediaType(String ctype) {
            super("multipart", "mixed");
            this.ctype = ctype;
        }

        public String toString() {
            return this.ctype;
        }
    }
}

