/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.model;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.lifecycle.LifeCycleException;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.types.ComplexType;

public interface Document {
    public Session getSession();

    public String getName();

    public Long getPos();

    public String getUUID();

    public Document getParent() throws DocumentException;

    public DocumentType getType();

    public String getPath() throws DocumentException;

    public void setPropertyValue(String var1, Serializable var2) throws DocumentException;

    public Serializable getPropertyValue(String var1) throws DocumentException;

    public boolean isFolder();

    public void setReadOnly(boolean var1);

    public boolean isReadOnly();

    public void remove() throws DocumentException;

    public String getLifeCycleState() throws LifeCycleException;

    public void setCurrentLifeCycleState(String var1) throws LifeCycleException;

    public String getLifeCyclePolicy() throws LifeCycleException;

    public void setLifeCyclePolicy(String var1) throws LifeCycleException;

    public void followTransition(String var1) throws LifeCycleException;

    public Collection<String> getAllowedStateTransitions() throws LifeCycleException;

    public boolean isProxy();

    public String getRepositoryName();

    public void setSystemProp(String var1, Serializable var2) throws DocumentException;

    public <T extends Serializable> T getSystemProp(String var1, Class<T> var2) throws DocumentException;

    public void readDocumentPart(DocumentPart var1) throws PropertyException;

    public Map<String, Serializable> readPrefetch(ComplexType var1, Set<String> var2) throws PropertyException;

    public void writeDocumentPart(DocumentPart var1) throws PropertyException;

    public Set<String> getAllFacets();

    public String[] getFacets();

    public boolean hasFacet(String var1);

    public boolean addFacet(String var1) throws DocumentException;

    public boolean removeFacet(String var1) throws DocumentException;

    public Lock setLock(Lock var1) throws DocumentException;

    public Lock removeLock(String var1) throws DocumentException;

    public Lock getLock() throws DocumentException;

    public Document getChild(String var1) throws DocumentException;

    public Iterator<Document> getChildren() throws DocumentException;

    public List<String> getChildrenIds() throws DocumentException;

    public boolean hasChild(String var1) throws DocumentException;

    public boolean hasChildren() throws DocumentException;

    public Document addChild(String var1, String var2) throws DocumentException;

    public void orderBefore(String var1, String var2) throws DocumentException;

    public Document checkIn(String var1, String var2) throws DocumentException;

    public void checkOut() throws DocumentException;

    public List<String> getVersionsIds() throws DocumentException;

    public List<Document> getVersions() throws DocumentException;

    public Document getLastVersion() throws DocumentException;

    public Document getSourceDocument() throws DocumentException;

    public void restore(Document var1) throws DocumentException;

    public Document getVersion(String var1) throws DocumentException;

    public boolean isVersion();

    public Document getBaseVersion() throws DocumentException;

    public boolean isCheckedOut() throws DocumentException;

    public Calendar getVersionCreationDate() throws DocumentException;

    public String getCheckinComment() throws DocumentException;

    public String getVersionSeriesId() throws DocumentException;

    public String getVersionLabel() throws DocumentException;

    public boolean isLatestVersion() throws DocumentException;

    public boolean isMajorVersion() throws DocumentException;

    public boolean isLatestMajorVersion() throws DocumentException;

    public boolean isVersionSeriesCheckedOut() throws DocumentException;

    public Document getWorkingCopy() throws DocumentException;

    public Document getTargetDocument() throws DocumentException;

    public void setTargetDocument(Document var1) throws DocumentException;
}

