/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.policy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.packed.GrowableWriter;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;

public final class ElasticsearchMergePolicy
extends MergePolicy {
    private final MergePolicy delegate;
    private volatile boolean force;

    public ElasticsearchMergePolicy(MergePolicy delegate) {
        this.delegate = delegate;
    }

    static AtomicReader filter(AtomicReader reader) throws IOException {
        FieldInfo newVersionInfo;
        FieldInfos fieldInfos = reader.getFieldInfos();
        FieldInfo versionInfo = fieldInfos.fieldInfo("_version");
        if (versionInfo != null && versionInfo.hasDocValues()) {
            return reader;
        }
        Terms terms = reader.terms("_uid");
        if (terms == null || !terms.hasPayloads()) {
            return reader;
        }
        TermsEnum uids = terms.iterator(null);
        final GrowableWriter versions = new GrowableWriter(2, reader.maxDoc(), 0.2f);
        DocsAndPositionsEnum dpe = null;
        BytesRef uid = uids.next();
        while (uid != null) {
            dpe = uids.docsAndPositions(reader.getLiveDocs(), dpe, 2);
            assert (dpe != null) : "field has payloads";
            int doc = dpe.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                dpe.nextPosition();
                BytesRef payload = dpe.getPayload();
                if (payload != null && payload.length == 8) {
                    long version = Numbers.bytesToLong(payload);
                    versions.set(doc, version);
                    break;
                }
                doc = dpe.nextDoc();
            }
            uid = uids.next();
        }
        if (versionInfo == null) {
            int fieldNumber = 0;
            for (FieldInfo fi : fieldInfos) {
                fieldNumber = Math.max(fieldNumber, fi.number + 1);
            }
            newVersionInfo = new FieldInfo("_version", false, fieldNumber, false, true, false, FieldInfo.IndexOptions.DOCS_ONLY, FieldInfo.DocValuesType.NUMERIC, FieldInfo.DocValuesType.NUMERIC, Collections.emptyMap());
        } else {
            newVersionInfo = new FieldInfo("_version", versionInfo.isIndexed(), versionInfo.number, versionInfo.hasVectors(), versionInfo.omitsNorms(), versionInfo.hasPayloads(), versionInfo.getIndexOptions(), versionInfo.getDocValuesType(), versionInfo.getNormType(), versionInfo.attributes());
        }
        ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
        for (FieldInfo info : fieldInfos) {
            if (info == versionInfo) continue;
            fieldInfoList.add(info);
        }
        fieldInfoList.add(newVersionInfo);
        final FieldInfos newFieldInfos = new FieldInfos(fieldInfoList.toArray(new FieldInfo[fieldInfoList.size()]));
        final NumericDocValues versionValues = new NumericDocValues(){

            public long get(int index) {
                return versions.get(index);
            }
        };
        return new FilterAtomicReader(reader){

            public FieldInfos getFieldInfos() {
                return newFieldInfos;
            }

            public NumericDocValues getNumericDocValues(String field) throws IOException {
                if ("_version".equals(field)) {
                    return versionValues;
                }
                return super.getNumericDocValues(field);
            }

            public Bits getDocsWithField(String field) throws IOException {
                return new Bits.MatchAllBits(this.in.maxDoc());
            }
        };
    }

    static MergePolicy.MergeSpecification upgradedMergeSpecification(MergePolicy.MergeSpecification spec) {
        if (spec == null) {
            return null;
        }
        IndexUpgraderMergeSpecification upgradedSpec = new IndexUpgraderMergeSpecification();
        for (MergePolicy.OneMerge merge : spec.merges) {
            upgradedSpec.add(merge);
        }
        return upgradedSpec;
    }

    public MergePolicy.MergeSpecification findMerges(MergePolicy.MergeTrigger mergeTrigger, SegmentInfos segmentInfos) throws IOException {
        return ElasticsearchMergePolicy.upgradedMergeSpecification(this.delegate.findMerges(mergeTrigger, segmentInfos));
    }

    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge) throws IOException {
        if (this.force) {
            ArrayList<SegmentCommitInfo> segments = Lists.newArrayList();
            for (SegmentCommitInfo info : segmentInfos) {
                if (!segmentsToMerge.containsKey(info)) continue;
                segments.add(info);
            }
            if (!segments.isEmpty()) {
                IndexUpgraderMergeSpecification spec = new IndexUpgraderMergeSpecification();
                spec.add(new MergePolicy.OneMerge(segments));
                return spec;
            }
        }
        return ElasticsearchMergePolicy.upgradedMergeSpecification(this.delegate.findForcedMerges(segmentInfos, maxSegmentCount, segmentsToMerge));
    }

    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos) throws IOException {
        return ElasticsearchMergePolicy.upgradedMergeSpecification(this.delegate.findForcedDeletesMerges(segmentInfos));
    }

    public MergePolicy clone() {
        return new ElasticsearchMergePolicy(this.delegate.clone());
    }

    public void close() {
        this.delegate.close();
    }

    public boolean useCompoundFile(SegmentInfos segments, SegmentCommitInfo newSegment) throws IOException {
        return this.delegate.useCompoundFile(segments, newSegment);
    }

    public void setIndexWriter(IndexWriter writer) {
        this.delegate.setIndexWriter(writer);
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.delegate + ")";
    }

    static class IndexUpgraderMergeSpecification
    extends MergePolicy.MergeSpecification {
        IndexUpgraderMergeSpecification() {
        }

        public void add(MergePolicy.OneMerge merge) {
            super.add((MergePolicy.OneMerge)new IndexUpgraderOneMerge(merge.segments));
        }

        public String segString(Directory dir) {
            return "IndexUpgraderMergeSpec[" + super.segString(dir) + "]";
        }
    }

    static class IndexUpgraderOneMerge
    extends MergePolicy.OneMerge {
        public IndexUpgraderOneMerge(List<SegmentCommitInfo> segments) {
            super(segments);
        }

        public List<AtomicReader> getMergeReaders() throws IOException {
            List readers = super.getMergeReaders();
            ImmutableList.Builder newReaders = ImmutableList.builder();
            for (AtomicReader reader : readers) {
                newReaders.add(ElasticsearchMergePolicy.filter(reader));
            }
            return newReaders.build();
        }
    }
}

