/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.FiltersFunctionScoreQuery;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.functionscore.ScoreFunctionParser;
import org.elasticsearch.index.query.functionscore.ScoreFunctionParserMapper;

public class FunctionScoreQueryParser
implements QueryParser {
    public static final String NAME = "function_score";
    ScoreFunctionParserMapper funtionParserMapper;
    private static final ImmutableMap<String, CombineFunction> combineFunctionsMap;

    @Inject
    public FunctionScoreQueryParser(ScoreFunctionParserMapper funtionParserMapper) {
        this.funtionParserMapper = funtionParserMapper;
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Object query = null;
        float boost = 1.0f;
        FiltersFunctionScoreQuery.ScoreMode scoreMode = FiltersFunctionScoreQuery.ScoreMode.Multiply;
        ArrayList<FiltersFunctionScoreQuery.FilterFunction> filterFunctions = new ArrayList<FiltersFunctionScoreQuery.FilterFunction>();
        float maxBoost = Float.MAX_VALUE;
        String currentFieldName = null;
        CombineFunction combineFunction = CombineFunction.MULT;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if ("query".equals(currentFieldName)) {
                query = parseContext.parseInnerQuery();
                continue;
            }
            if ("filter".equals(currentFieldName)) {
                query = new XConstantScoreQuery(parseContext.parseInnerFilter());
                continue;
            }
            if ("score_mode".equals(currentFieldName) || "scoreMode".equals(currentFieldName)) {
                scoreMode = this.parseScoreMode(parseContext, parser);
                continue;
            }
            if ("boost_mode".equals(currentFieldName) || "boostMode".equals(currentFieldName)) {
                combineFunction = this.parseBoostMode(parseContext, parser);
                continue;
            }
            if ("max_boost".equals(currentFieldName) || "maxBoost".equals(currentFieldName)) {
                maxBoost = parser.floatValue();
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("functions".equals(currentFieldName)) {
                currentFieldName = this.parseFiltersAndFunctions(parseContext, parser, filterFunctions, currentFieldName);
                continue;
            }
            filterFunctions.add(new FiltersFunctionScoreQuery.FilterFunction(null, this.funtionParserMapper.get(parseContext.index(), currentFieldName).parse(parseContext, parser)));
        }
        if (query == null) {
            query = Queries.newMatchAllQuery();
        }
        if (filterFunctions.isEmpty()) {
            return query;
        }
        if (filterFunctions.size() == 1 && ((FiltersFunctionScoreQuery.FilterFunction)filterFunctions.get((int)0)).filter == null) {
            FunctionScoreQuery theQuery = new FunctionScoreQuery((Query)query, ((FiltersFunctionScoreQuery.FilterFunction)filterFunctions.get((int)0)).function);
            if (combineFunction != null) {
                theQuery.setCombineFunction(combineFunction);
            }
            theQuery.setBoost(boost);
            theQuery.setMaxBoost(maxBoost);
            return theQuery;
        }
        FiltersFunctionScoreQuery functionScoreQuery = new FiltersFunctionScoreQuery((Query)query, scoreMode, filterFunctions.toArray(new FiltersFunctionScoreQuery.FilterFunction[filterFunctions.size()]), maxBoost);
        if (combineFunction != null) {
            functionScoreQuery.setCombineFunction(combineFunction);
        }
        functionScoreQuery.setBoost(boost);
        return functionScoreQuery;
    }

    private String parseFiltersAndFunctions(QueryParseContext parseContext, XContentParser parser, ArrayList<FiltersFunctionScoreQuery.FilterFunction> filterFunctions, String currentFieldName) throws IOException {
        XContentParser.Token token;
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            Filter filter = null;
            ScoreFunction scoreFunction = null;
            if (token != XContentParser.Token.START_OBJECT) {
                throw new QueryParsingException(parseContext.index(), "function_score: malformed query, expected a " + (Object)((Object)XContentParser.Token.START_OBJECT) + " while parsing functions but got a " + (Object)((Object)token));
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if ("filter".equals(currentFieldName)) {
                    filter = parseContext.parseInnerFilter();
                    continue;
                }
                ScoreFunctionParser functionParser = this.funtionParserMapper.get(parseContext.index(), currentFieldName);
                scoreFunction = functionParser.parse(parseContext, parser);
            }
            if (filter == null) {
                filter = Queries.MATCH_ALL_FILTER;
            }
            filterFunctions.add(new FiltersFunctionScoreQuery.FilterFunction(filter, scoreFunction));
        }
        return currentFieldName;
    }

    private FiltersFunctionScoreQuery.ScoreMode parseScoreMode(QueryParseContext parseContext, XContentParser parser) throws IOException {
        String scoreMode = parser.text();
        if ("avg".equals(scoreMode)) {
            return FiltersFunctionScoreQuery.ScoreMode.Avg;
        }
        if ("max".equals(scoreMode)) {
            return FiltersFunctionScoreQuery.ScoreMode.Max;
        }
        if ("min".equals(scoreMode)) {
            return FiltersFunctionScoreQuery.ScoreMode.Min;
        }
        if ("sum".equals(scoreMode)) {
            return FiltersFunctionScoreQuery.ScoreMode.Sum;
        }
        if ("multiply".equals(scoreMode)) {
            return FiltersFunctionScoreQuery.ScoreMode.Multiply;
        }
        if ("first".equals(scoreMode)) {
            return FiltersFunctionScoreQuery.ScoreMode.First;
        }
        throw new QueryParsingException(parseContext.index(), "function_score illegal score_mode [" + scoreMode + "]");
    }

    private CombineFunction parseBoostMode(QueryParseContext parseContext, XContentParser parser) throws IOException {
        String boostMode = parser.text();
        CombineFunction cf = combineFunctionsMap.get(boostMode);
        if (cf == null) {
            throw new QueryParsingException(parseContext.index(), "function_score illegal boost_mode [" + boostMode + "]");
        }
        return cf;
    }

    static {
        CombineFunction[] values = CombineFunction.values();
        ImmutableMap.Builder<String, CombineFunction> combineFunctionMapBuilder = ImmutableMap.builder();
        for (CombineFunction combineFunction : values) {
            combineFunctionMapBuilder.put(combineFunction.getName(), combineFunction);
        }
        combineFunctionsMap = combineFunctionMapBuilder.build();
    }
}

