/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.store.RateLimiter;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.node.settings.NodeSettingsService;

public class RecoverySettings
extends AbstractComponent {
    public static final String INDICES_RECOVERY_FILE_CHUNK_SIZE = "indices.recovery.file_chunk_size";
    public static final String INDICES_RECOVERY_TRANSLOG_OPS = "indices.recovery.translog_ops";
    public static final String INDICES_RECOVERY_TRANSLOG_SIZE = "indices.recovery.translog_size";
    public static final String INDICES_RECOVERY_COMPRESS = "indices.recovery.compress";
    public static final String INDICES_RECOVERY_CONCURRENT_STREAMS = "indices.recovery.concurrent_streams";
    public static final String INDICES_RECOVERY_CONCURRENT_SMALL_FILE_STREAMS = "indices.recovery.concurrent_small_file_streams";
    public static final String INDICES_RECOVERY_MAX_BYTES_PER_SEC = "indices.recovery.max_bytes_per_sec";
    public static final long SMALL_FILE_CUTOFF_BYTES = ByteSizeValue.parseBytesSizeValue("5mb").bytes();
    @Deprecated
    public static final String INDICES_RECOVERY_MAX_SIZE_PER_SEC = "indices.recovery.max_size_per_sec";
    private volatile ByteSizeValue fileChunkSize;
    private volatile boolean compress;
    private volatile int translogOps;
    private volatile ByteSizeValue translogSize;
    private volatile int concurrentStreams;
    private volatile int concurrentSmallFileStreams;
    private final ThreadPoolExecutor concurrentStreamPool;
    private final ThreadPoolExecutor concurrentSmallFileStreamPool;
    private volatile ByteSizeValue maxBytesPerSec;
    private volatile RateLimiter.SimpleRateLimiter rateLimiter;

    @Inject
    public RecoverySettings(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        this.fileChunkSize = this.componentSettings.getAsBytesSize("file_chunk_size", settings.getAsBytesSize("index.shard.recovery.file_chunk_size", new ByteSizeValue(512L, ByteSizeUnit.KB)));
        this.translogOps = this.componentSettings.getAsInt("translog_ops", settings.getAsInt("index.shard.recovery.translog_ops", (Integer)1000));
        this.translogSize = this.componentSettings.getAsBytesSize("translog_size", settings.getAsBytesSize("index.shard.recovery.translog_size", new ByteSizeValue(512L, ByteSizeUnit.KB)));
        this.compress = this.componentSettings.getAsBoolean("compress", (Boolean)true);
        this.concurrentStreams = this.componentSettings.getAsInt("concurrent_streams", settings.getAsInt("index.shard.recovery.concurrent_streams", (Integer)3));
        this.concurrentStreamPool = EsExecutors.newScaling(0, this.concurrentStreams, 60L, TimeUnit.SECONDS, EsExecutors.daemonThreadFactory(settings, "[recovery_stream]"));
        this.concurrentSmallFileStreams = this.componentSettings.getAsInt("concurrent_small_file_streams", settings.getAsInt("index.shard.recovery.concurrent_small_file_streams", (Integer)2));
        this.concurrentSmallFileStreamPool = EsExecutors.newScaling(0, this.concurrentSmallFileStreams, 60L, TimeUnit.SECONDS, EsExecutors.daemonThreadFactory(settings, "[small_file_recovery_stream]"));
        this.maxBytesPerSec = this.componentSettings.getAsBytesSize("max_bytes_per_sec", this.componentSettings.getAsBytesSize("max_size_per_sec", new ByteSizeValue(20L, ByteSizeUnit.MB)));
        this.rateLimiter = this.maxBytesPerSec.bytes() <= 0L ? null : new RateLimiter.SimpleRateLimiter(this.maxBytesPerSec.mbFrac());
        this.logger.debug("using max_bytes_per_sec[{}], concurrent_streams [{}], file_chunk_size [{}], translog_size [{}], translog_ops [{}], and compress [{}]", this.maxBytesPerSec, this.concurrentStreams, this.fileChunkSize, this.translogSize, this.translogOps, this.compress);
        nodeSettingsService.addListener(new ApplySettings());
    }

    public void close() {
        this.concurrentStreamPool.shutdown();
        try {
            this.concurrentStreamPool.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.concurrentStreamPool.shutdownNow();
    }

    public ByteSizeValue fileChunkSize() {
        return this.fileChunkSize;
    }

    public boolean compress() {
        return this.compress;
    }

    public int translogOps() {
        return this.translogOps;
    }

    public ByteSizeValue translogSize() {
        return this.translogSize;
    }

    public int concurrentStreams() {
        return this.concurrentStreams;
    }

    public ThreadPoolExecutor concurrentStreamPool() {
        return this.concurrentStreamPool;
    }

    public ThreadPoolExecutor concurrentSmallFileStreamPool() {
        return this.concurrentSmallFileStreamPool;
    }

    public RateLimiter rateLimiter() {
        return this.rateLimiter;
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            int concurrentSmallFileStreams;
            int concurrentStreams;
            boolean compress;
            ByteSizeValue translogSize;
            int translogOps;
            ByteSizeValue fileChunkSize;
            ByteSizeValue maxSizePerSec = settings.getAsBytesSize(RecoverySettings.INDICES_RECOVERY_MAX_BYTES_PER_SEC, settings.getAsBytesSize(RecoverySettings.INDICES_RECOVERY_MAX_SIZE_PER_SEC, RecoverySettings.this.maxBytesPerSec));
            if (!Objects.equal(maxSizePerSec, RecoverySettings.this.maxBytesPerSec)) {
                RecoverySettings.this.logger.info("updating [{}] from [{}] to [{}]", RecoverySettings.INDICES_RECOVERY_MAX_BYTES_PER_SEC, RecoverySettings.this.maxBytesPerSec, maxSizePerSec);
                RecoverySettings.this.maxBytesPerSec = maxSizePerSec;
                if (maxSizePerSec.bytes() <= 0L) {
                    RecoverySettings.this.rateLimiter = null;
                } else if (RecoverySettings.this.rateLimiter != null) {
                    RecoverySettings.this.rateLimiter.setMbPerSec(maxSizePerSec.mbFrac());
                } else {
                    RecoverySettings.this.rateLimiter = new RateLimiter.SimpleRateLimiter(maxSizePerSec.mbFrac());
                }
            }
            if (!(fileChunkSize = settings.getAsBytesSize(RecoverySettings.INDICES_RECOVERY_FILE_CHUNK_SIZE, RecoverySettings.this.fileChunkSize)).equals(RecoverySettings.this.fileChunkSize)) {
                RecoverySettings.this.logger.info("updating [indices.recovery.file_chunk_size] from [{}] to [{}]", RecoverySettings.this.fileChunkSize, fileChunkSize);
                RecoverySettings.this.fileChunkSize = fileChunkSize;
            }
            if ((translogOps = settings.getAsInt(RecoverySettings.INDICES_RECOVERY_TRANSLOG_OPS, (Integer)RecoverySettings.this.translogOps).intValue()) != RecoverySettings.this.translogOps) {
                RecoverySettings.this.logger.info("updating [indices.recovery.translog_ops] from [{}] to [{}]", RecoverySettings.this.translogOps, translogOps);
                RecoverySettings.this.translogOps = translogOps;
            }
            if (!(translogSize = settings.getAsBytesSize(RecoverySettings.INDICES_RECOVERY_TRANSLOG_SIZE, RecoverySettings.this.translogSize)).equals(RecoverySettings.this.translogSize)) {
                RecoverySettings.this.logger.info("updating [indices.recovery.translog_size] from [{}] to [{}]", RecoverySettings.this.translogSize, translogSize);
                RecoverySettings.this.translogSize = translogSize;
            }
            if ((compress = settings.getAsBoolean(RecoverySettings.INDICES_RECOVERY_COMPRESS, (Boolean)RecoverySettings.this.compress).booleanValue()) != RecoverySettings.this.compress) {
                RecoverySettings.this.logger.info("updating [indices.recovery.compress] from [{}] to [{}]", RecoverySettings.this.compress, compress);
                RecoverySettings.this.compress = compress;
            }
            if ((concurrentStreams = settings.getAsInt(RecoverySettings.INDICES_RECOVERY_CONCURRENT_STREAMS, (Integer)RecoverySettings.this.concurrentStreams).intValue()) != RecoverySettings.this.concurrentStreams) {
                RecoverySettings.this.logger.info("updating [indices.recovery.concurrent_streams] from [{}] to [{}]", RecoverySettings.this.concurrentStreams, concurrentStreams);
                RecoverySettings.this.concurrentStreams = concurrentStreams;
                RecoverySettings.this.concurrentStreamPool.setMaximumPoolSize(concurrentStreams);
            }
            if ((concurrentSmallFileStreams = settings.getAsInt(RecoverySettings.INDICES_RECOVERY_CONCURRENT_SMALL_FILE_STREAMS, (Integer)RecoverySettings.this.concurrentSmallFileStreams).intValue()) != RecoverySettings.this.concurrentSmallFileStreams) {
                RecoverySettings.this.logger.info("updating [indices.recovery.concurrent_small_file_streams] from [{}] to [{}]", RecoverySettings.this.concurrentSmallFileStreams, concurrentSmallFileStreams);
                RecoverySettings.this.concurrentSmallFileStreams = concurrentSmallFileStreams;
                RecoverySettings.this.concurrentSmallFileStreamPool.setMaximumPoolSize(concurrentSmallFileStreams);
            }
        }
    }
}

