/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.dump;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.monitor.dump.DumpContributor;
import org.elasticsearch.monitor.dump.DumpContributorFactory;
import org.elasticsearch.monitor.dump.DumpGenerationFailedException;
import org.elasticsearch.monitor.dump.DumpGenerator;
import org.elasticsearch.monitor.dump.SimpleDumpGenerator;
import org.elasticsearch.monitor.dump.heap.HeapDumpContributor;
import org.elasticsearch.monitor.dump.summary.SummaryDumpContributor;
import org.elasticsearch.monitor.dump.thread.ThreadDumpContributor;

public class DumpMonitorService
extends AbstractComponent {
    private final String dumpLocation;
    private final DumpGenerator generator;
    private final ClusterService clusterService;
    private final Map<String, Settings> contSettings;
    private final Map<String, DumpContributorFactory> contributors;
    private final File workFile;

    public DumpMonitorService() {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS, new Environment(ImmutableSettings.Builder.EMPTY_SETTINGS), null, null);
    }

    @Inject
    public DumpMonitorService(Settings settings, Environment environment, @Nullable ClusterService clusterService, @Nullable Map<String, DumpContributorFactory> contributors) {
        super(settings);
        this.clusterService = clusterService;
        this.contributors = contributors;
        this.contSettings = settings.getGroups("monitor.dump");
        this.workFile = environment.workWithClusterFile();
        this.dumpLocation = settings.get("dump_location");
        File dumpLocationFile = this.dumpLocation != null ? new File(this.dumpLocation) : new File(this.workFile, "dump");
        HashMap<String, DumpContributor> contributorMap = Maps.newHashMap();
        if (contributors != null) {
            for (Map.Entry<String, DumpContributorFactory> entry : contributors.entrySet()) {
                String contName = entry.getKey();
                DumpContributorFactory dumpContributorFactory = entry.getValue();
                Settings analyzerSettings = this.contSettings.get(contName);
                if (analyzerSettings == null) {
                    analyzerSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
                }
                DumpContributor analyzerFactory = dumpContributorFactory.create(contName, analyzerSettings);
                contributorMap.put(contName, analyzerFactory);
            }
        }
        if (!contributorMap.containsKey("summary")) {
            contributorMap.put("summary", new SummaryDumpContributor("summary", ImmutableSettings.Builder.EMPTY_SETTINGS));
        }
        if (!contributorMap.containsKey("heap")) {
            contributorMap.put("heap", new HeapDumpContributor("heap", ImmutableSettings.Builder.EMPTY_SETTINGS));
        }
        if (!contributorMap.containsKey("thread")) {
            contributorMap.put("thread", new ThreadDumpContributor("thread", ImmutableSettings.Builder.EMPTY_SETTINGS));
        }
        this.generator = new SimpleDumpGenerator(dumpLocationFile, contributorMap);
    }

    public DumpGenerator.Result generateDump(String cause, @Nullable Map<String, Object> context) throws DumpGenerationFailedException {
        return this.generator.generateDump(cause, this.fillContextMap(context));
    }

    public DumpGenerator.Result generateDump(String cause, @Nullable Map<String, Object> context, String ... contributors) throws DumpGenerationFailedException {
        return this.generator.generateDump(cause, this.fillContextMap(context), contributors);
    }

    private Map<String, Object> fillContextMap(Map<String, Object> context) {
        if (context == null) {
            context = Maps.newHashMap();
        }
        if (this.clusterService != null) {
            context.put("localNode", this.clusterService.localNode());
        }
        return context;
    }
}

