/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.text.BytesText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.significant.InternalSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTerms;

public class SignificantStringTerms
extends InternalSignificantTerms {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("significant_terms", "sigsterms");
    public static AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public SignificantStringTerms readResult(StreamInput in) throws IOException {
            SignificantStringTerms buckets = new SignificantStringTerms();
            buckets.readFrom(in);
            return buckets;
        }
    };

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    SignificantStringTerms() {
    }

    public SignificantStringTerms(long subsetSize, long supersetSize, String name, int requiredSize, long minDocCount, Collection<InternalSignificantTerms.Bucket> buckets) {
        super(subsetSize, supersetSize, name, requiredSize, minDocCount, buckets);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.requiredSize = SignificantStringTerms.readSize(in);
        this.minDocCount = in.readVLong();
        this.subsetSize = in.readVLong();
        this.supersetSize = in.readVLong();
        int size = in.readVInt();
        ArrayList<Bucket> buckets = new ArrayList<Bucket>(size);
        for (int i = 0; i < size; ++i) {
            BytesRef term = in.readBytesRef();
            long subsetDf = in.readVLong();
            long supersetDf = in.readVLong();
            buckets.add(new Bucket(term, subsetDf, this.subsetSize, supersetDf, this.supersetSize, InternalAggregations.readAggregations(in)));
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        SignificantStringTerms.writeSize(this.requiredSize, out);
        out.writeVLong(this.minDocCount);
        out.writeVLong(this.subsetSize);
        out.writeVLong(this.supersetSize);
        out.writeVInt(this.buckets.size());
        for (InternalSignificantTerms.Bucket bucket : this.buckets) {
            out.writeBytesRef(((Bucket)bucket).termBytes);
            out.writeVLong(((Bucket)bucket).subsetDf);
            out.writeVLong(((Bucket)bucket).supersetDf);
            ((InternalAggregations)bucket.getAggregations()).writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field("doc_count", this.subsetSize);
        builder.startArray(InternalAggregation.CommonFields.BUCKETS);
        for (InternalSignificantTerms.Bucket bucket : this.buckets) {
            if (bucket.subsetDf < this.minDocCount) continue;
            builder.startObject();
            builder.field(InternalAggregation.CommonFields.KEY, ((Bucket)bucket).termBytes);
            builder.field(InternalAggregation.CommonFields.DOC_COUNT, bucket.getDocCount());
            builder.field("score", bucket.score);
            builder.field("bg_count", bucket.supersetDf);
            ((InternalAggregations)bucket.getAggregations()).toXContentInternal(builder, params);
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static class Bucket
    extends InternalSignificantTerms.Bucket {
        BytesRef termBytes;

        public Bucket(BytesRef term, long subsetDf, long subsetSize, long supersetDf, long supersetSize, InternalAggregations aggregations) {
            super(subsetDf, subsetSize, supersetDf, supersetSize, aggregations);
            this.termBytes = term;
        }

        @Override
        public Text getKeyAsText() {
            return new BytesText(new BytesArray(this.termBytes));
        }

        @Override
        public Number getKeyAsNumber() {
            return Double.parseDouble(this.termBytes.utf8ToString());
        }

        @Override
        int compareTerm(SignificantTerms.Bucket other) {
            return BytesRef.getUTF8SortedAsUnicodeComparator().compare(this.termBytes, ((Bucket)other).termBytes);
        }

        @Override
        public String getKey() {
            return this.termBytes.utf8ToString();
        }
    }
}

