/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantStringTerms;

public class SignificantTermsBuilder
extends AggregationBuilder<SignificantTermsBuilder> {
    private String field;
    private int requiredSize = 10;
    private int shardSize = 0;
    private int minDocCount = 3;

    public SignificantTermsBuilder(String name) {
        super(name, SignificantStringTerms.TYPE.name());
    }

    public SignificantTermsBuilder field(String field) {
        this.field = field;
        return this;
    }

    public SignificantTermsBuilder size(int requiredSize) {
        this.requiredSize = requiredSize;
        return this;
    }

    public SignificantTermsBuilder shardSize(int shardSize) {
        this.shardSize = shardSize;
        return this;
    }

    public SignificantTermsBuilder minDocCount(int minDocCount) {
        this.minDocCount = minDocCount;
        return this;
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.field != null) {
            builder.field("field", this.field);
        }
        if (this.minDocCount != 3) {
            builder.field("minDocCount", this.minDocCount);
        }
        if (this.requiredSize != 10) {
            builder.field("size", this.requiredSize);
        }
        if (this.shardSize != 0) {
            builder.field("shard_size", this.shardSize);
        }
        return builder.endObject();
    }
}

