/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class UnmappedTermsAggregator
extends Aggregator {
    private final InternalOrder order;
    private final int requiredSize;
    private final long minDocCount;

    public UnmappedTermsAggregator(String name, InternalOrder order, int requiredSize, long minDocCount, AggregationContext aggregationContext, Aggregator parent) {
        super(name, Aggregator.BucketAggregationMode.PER_BUCKET, AggregatorFactories.EMPTY, 0L, aggregationContext, parent);
        this.order = order;
        this.requiredSize = requiredSize;
        this.minDocCount = minDocCount;
    }

    @Override
    public boolean shouldCollect() {
        return false;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        assert (owningBucketOrdinal == 0L);
        return new UnmappedTerms(this.name, this.order, this.requiredSize, this.minDocCount);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new UnmappedTerms(this.name, this.order, this.requiredSize, this.minDocCount);
    }
}

