/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles.tdigest;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.OpenBitSet;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.hppc.IntArrayDeque;
import org.elasticsearch.common.hppc.cursors.IntCursor;

public abstract class RedBlackTree
implements Iterable<IntCursor> {
    protected static final int NIL = 0;
    private static final boolean BLACK = false;
    private static final boolean RED = true;
    private int size = 0;
    private int maxNode = 1;
    private int root = 0;
    private final IntArrayDeque unusedSlots;
    private int[] leftNodes;
    private int[] rightNodes;
    private int[] parentNodes;
    private final OpenBitSet colors;

    protected RedBlackTree(int capacity) {
        this.leftNodes = new int[1 + capacity];
        this.rightNodes = new int[1 + capacity];
        this.parentNodes = new int[1 + capacity];
        this.colors = new OpenBitSet((long)(1 + capacity));
        this.unusedSlots = new IntArrayDeque();
    }

    protected final int root() {
        assert (this.size > 0 || this.root == 0);
        return this.root;
    }

    protected void releaseNode(int node) {
        this.unusedSlots.addLast(node);
        this.parent(node, 0);
        this.left(node, 0);
        this.right(node, 0);
    }

    protected int newNode() {
        if (this.unusedSlots.isEmpty()) {
            int slot = this.maxNode++;
            if (this.maxNode > this.leftNodes.length) {
                int minSize = ArrayUtil.oversize((int)this.maxNode, (int)4);
                this.leftNodes = Arrays.copyOf(this.leftNodes, minSize);
                this.rightNodes = Arrays.copyOf(this.rightNodes, minSize);
                this.parentNodes = Arrays.copyOf(this.parentNodes, minSize);
                this.colors.ensureCapacity((long)this.leftNodes.length);
            }
            return slot;
        }
        return this.unusedSlots.removeLast();
    }

    public int size() {
        assert (this.size == this.maxNode - this.unusedSlots.size() - 1) : this.size + " != " + (this.maxNode - this.unusedSlots.size() - 1);
        return this.size;
    }

    private boolean color(int node) {
        return this.colors.get(node);
    }

    private void color(int node, boolean color) {
        assert (node != 0);
        if (color) {
            this.colors.fastSet(node);
        } else {
            this.colors.fastClear(node);
        }
    }

    protected final int parent(int node) {
        return this.parentNodes[node];
    }

    private void parent(int node, int parent) {
        assert (node != 0);
        this.parentNodes[node] = parent;
    }

    protected final int left(int node) {
        assert (node != 0);
        return this.leftNodes[node];
    }

    protected void left(int node, int leftNode) {
        assert (node != 0);
        this.leftNodes[node] = leftNode;
    }

    protected final int right(int node) {
        assert (node != 0);
        return this.rightNodes[node];
    }

    private void right(int node, int rightNode) {
        assert (node != 0);
        this.rightNodes[node] = rightNode;
    }

    private int numBlackNode(int node) {
        assert (this.assertConsistent(node));
        if (node == 0) {
            return 1;
        }
        int numLeft = this.numBlackNode(this.left(node));
        int numRight = this.numBlackNode(this.right(node));
        assert (numLeft == numRight) : numLeft + " " + numRight;
        int num = numLeft;
        if (!this.color(node)) {
            ++num;
        }
        return num;
    }

    private boolean assertConsistent(int node) {
        if (node == 0) {
            return true;
        }
        int parent = this.parent(node);
        if (parent == 0 ? !$assertionsDisabled && node != this.root : !$assertionsDisabled && node != this.left(parent) && node != this.right(parent)) {
            throw new AssertionError();
        }
        int left = this.left(node);
        if (left != 0) assert (this.parent(left) == node);
        int right = this.right(node);
        if (right != 0) assert (this.parent(right) == node);
        return true;
    }

    public void assertConsistent() {
        this.numBlackNode(this.root);
    }

    protected void rotateLeft(int n) {
        int r = this.right(n);
        int lr = this.left(r);
        this.right(n, this.left(r));
        if (lr != 0) {
            this.parent(lr, n);
        }
        int p = this.parent(n);
        this.parent(r, p);
        if (p == 0) {
            this.root = r;
        } else if (this.left(p) == n) {
            this.left(p, r);
        } else {
            assert (this.right(p) == n);
            this.right(p, r);
        }
        this.left(r, n);
        this.parent(n, r);
    }

    protected void rotateRight(int n) {
        int l = this.left(n);
        int rl = this.right(l);
        this.left(n, rl);
        if (rl != 0) {
            this.parent(rl, n);
        }
        int p = this.parent(n);
        this.parent(l, p);
        if (p == 0) {
            this.root = l;
        } else if (this.right(p) == n) {
            this.right(p, l);
        } else {
            assert (this.left(p) == n);
            this.left(p, l);
        }
        this.right(l, n);
        this.parent(n, l);
    }

    protected void afterInsertion(int node) {
        this.color(node, true);
        this.insertCase1(node);
    }

    private void insertCase1(int node) {
        int parent = this.parent(node);
        if (parent == 0) {
            assert (node == this.root);
            this.color(node, false);
        } else {
            this.insertCase2(node, parent);
        }
    }

    private void insertCase2(int node, int parent) {
        if (this.color(parent)) {
            this.insertCase3(node, parent);
        }
    }

    private void insertCase3(int node, int parent) {
        int uncle;
        int grandParent = this.parent(parent);
        assert (grandParent != 0);
        if (parent == this.left(grandParent)) {
            uncle = this.right(grandParent);
        } else {
            assert (parent == this.right(grandParent));
            uncle = this.left(grandParent);
        }
        if (uncle != 0 && this.color(uncle)) {
            this.color(parent, false);
            this.color(uncle, false);
            this.color(grandParent, true);
            this.insertCase1(grandParent);
        } else {
            this.insertCase4(node, parent, grandParent);
        }
    }

    private void insertCase4(int node, int parent, int grandParent) {
        if (node == this.right(parent) && parent == this.left(grandParent)) {
            this.rotateLeft(parent);
            node = this.left(node);
        } else if (node == this.left(parent) && parent == this.right(grandParent)) {
            this.rotateRight(parent);
            node = this.right(node);
        }
        this.insertCase5(node);
    }

    private void insertCase5(int node) {
        int parent = this.parent(node);
        int grandParent = this.parent(parent);
        this.color(parent, false);
        this.color(grandParent, true);
        if (node == this.left(parent)) {
            this.rotateRight(grandParent);
        } else {
            assert (node == this.right(parent));
            this.rotateLeft(grandParent);
        }
    }

    protected void beforeRemoval(int node) {
    }

    protected void afterRemoval(int node) {
        assert (node != 0);
        if (!this.color(node)) {
            this.removeCase1(node);
        }
    }

    private int sibling(int node, int parent) {
        int left = this.left(parent);
        if (node == left) {
            return this.right(parent);
        }
        assert (node == this.right(parent));
        return left;
    }

    private void removeCase1(int node) {
        if (this.parent(node) != 0) {
            this.removeCase2(node);
        }
    }

    private void removeCase2(int node) {
        int parent = this.parent(node);
        int sibling = this.sibling(node, parent);
        if (this.color(sibling)) {
            this.color(sibling, false);
            this.color(parent, true);
            if (node == this.left(parent)) {
                this.rotateLeft(parent);
            } else {
                assert (node == this.right(parent));
                this.rotateRight(parent);
            }
        }
        this.removeCase3(node);
    }

    private void removeCase3(int node) {
        int parent = this.parent(node);
        int sibling = this.sibling(node, parent);
        if (!(this.color(parent) || sibling == 0 || this.color(sibling) || this.color(this.left(sibling)) || this.color(this.right(sibling)))) {
            this.color(sibling, true);
            this.removeCase1(parent);
        } else {
            this.removeCase4(node, parent, sibling);
        }
    }

    private void removeCase4(int node, int parent, int sibling) {
        if (this.color(parent) && sibling != 0 && !this.color(sibling) && !this.color(this.left(sibling)) && !this.color(this.right(sibling))) {
            this.color(sibling, true);
            this.color(parent, false);
        } else {
            this.removeCase5(node, parent, sibling);
        }
    }

    private void removeCase5(int node, int parent, int sibling) {
        if (!this.color(sibling)) {
            if (node == this.left(parent) && sibling != 0 && this.color(this.left(sibling)) && !this.color(this.right(sibling))) {
                this.color(sibling, true);
                this.color(this.left(sibling), false);
                this.rotateRight(sibling);
            } else if (node == this.right(parent) && sibling != 0 && !this.color(this.left(sibling)) && this.color(this.right(sibling))) {
                this.color(sibling, true);
                this.color(this.right(sibling), false);
                this.rotateLeft(sibling);
            }
        }
        this.removeCase6(node);
    }

    private void removeCase6(int node) {
        int parent = this.parent(node);
        int sibling = this.sibling(node, parent);
        this.color(sibling, this.color(parent));
        this.color(parent, false);
        if (node == this.left(parent)) {
            this.color(this.right(sibling), false);
            this.rotateLeft(parent);
        } else {
            assert (node == this.right(parent));
            this.color(this.left(sibling), false);
            this.rotateRight(parent);
        }
    }

    protected abstract int compare(int var1);

    protected abstract void copy(int var1);

    protected abstract void merge(int var1);

    public boolean addNode() {
        int newNode = 0;
        if (this.size == 0) {
            newNode = this.root = this.newNode();
            this.copy(this.root);
        } else {
            int cmp;
            int parent = 0;
            int node = this.root;
            do {
                if ((cmp = this.compare(node)) < 0) {
                    parent = node;
                    node = this.left(node);
                    continue;
                }
                if (cmp > 0) {
                    parent = node;
                    node = this.right(node);
                    continue;
                }
                this.merge(node);
                return false;
            } while (node != 0);
            newNode = this.newNode();
            this.copy(newNode);
            if (cmp < 0) {
                this.left(parent, newNode);
            } else {
                assert (cmp > 0);
                this.right(parent, newNode);
            }
            this.parent(newNode, parent);
        }
        ++this.size;
        this.afterInsertion(newNode);
        return true;
    }

    public int getNode() {
        if (this.size() == 0) {
            return 0;
        }
        int node = this.root;
        do {
            int cmp;
            if ((cmp = this.compare(node)) < 0) {
                node = this.left(node);
                continue;
            }
            if (cmp > 0) {
                node = this.right(node);
                continue;
            }
            return node;
        } while (node != 0);
        return 0;
    }

    protected void swap(int node1, int node2) {
        int parent1 = this.parent(node1);
        int parent2 = this.parent(node2);
        if (parent1 != 0) {
            if (node1 == this.left(parent1)) {
                this.left(parent1, node2);
            } else {
                assert (node1 == this.right(parent1));
                this.right(parent1, node2);
            }
        } else {
            assert (this.root == node1);
            this.root = node2;
        }
        if (parent2 != 0) {
            if (node2 == this.left(parent2)) {
                this.left(parent2, node1);
            } else {
                assert (node2 == this.right(parent2));
                this.right(parent2, node1);
            }
        } else {
            assert (this.root == node2);
            this.root = node1;
        }
        this.parent(node1, parent2);
        this.parent(node2, parent1);
        int left1 = this.left(node1);
        int left2 = this.left(node2);
        this.left(node1, left2);
        if (left2 != 0) {
            this.parent(left2, node1);
        }
        this.left(node2, left1);
        if (left1 != 0) {
            this.parent(left1, node2);
        }
        int right1 = this.right(node1);
        int right2 = this.right(node2);
        this.right(node1, right2);
        if (right2 != 0) {
            this.parent(right2, node1);
        }
        this.right(node2, right1);
        if (right1 != 0) {
            this.parent(right1, node2);
        }
        boolean color1 = this.color(node1);
        boolean color2 = this.color(node2);
        this.color(node1, color2);
        this.color(node2, color1);
        this.assertConsistent(node1);
        this.assertConsistent(node2);
    }

    public void removeNode(int nodeToRemove) {
        int next;
        assert (nodeToRemove != 0);
        if (this.left(nodeToRemove) != 0 && this.right(nodeToRemove) != 0 && (next = this.nextNode(nodeToRemove)) != 0) {
            this.swap(nodeToRemove, next);
        }
        assert (this.left(nodeToRemove) == 0 || this.right(nodeToRemove) == 0);
        int left = this.left(nodeToRemove);
        int child = left != 0 ? left : this.right(nodeToRemove);
        this.beforeRemoval(nodeToRemove);
        if (child != 0) {
            int parent = this.parent(nodeToRemove);
            this.parent(child, parent);
            if (parent != 0) {
                if (nodeToRemove == this.left(parent)) {
                    this.left(parent, child);
                } else {
                    assert (nodeToRemove == this.right(parent));
                    this.right(parent, child);
                }
            } else {
                assert (nodeToRemove == this.root);
                this.root = child;
            }
            if (!this.color(nodeToRemove)) {
                this.color(child, false);
            } else {
                this.afterRemoval(child);
            }
        } else {
            int parent = this.parent(nodeToRemove);
            if (parent == 0) {
                assert (nodeToRemove == this.root);
                this.root = 0;
            } else {
                this.afterRemoval(nodeToRemove);
                if (nodeToRemove == this.left(parent)) {
                    this.left(parent, 0);
                } else {
                    assert (nodeToRemove == this.right(parent));
                    this.right(parent, 0);
                }
            }
        }
        this.releaseNode(nodeToRemove);
        --this.size;
    }

    protected final int first(int node) {
        int left;
        if (node == 0) {
            return 0;
        }
        while ((left = this.left(node)) != 0) {
            node = left;
        }
        return node;
    }

    protected final int last(int node) {
        int right;
        while ((right = this.right(node)) != 0) {
            node = right;
        }
        return node;
    }

    public final int prevNode(int node) {
        int left = this.left(node);
        if (left != 0) {
            return this.last(left);
        }
        int parent = this.parent(node);
        while (parent != 0 && node == this.left(parent)) {
            node = parent;
            parent = this.parent(parent);
        }
        return parent;
    }

    public final int nextNode(int node) {
        int right = this.right(node);
        if (right != 0) {
            return this.first(right);
        }
        int parent = this.parent(node);
        while (parent != 0 && node == this.right(parent)) {
            node = parent;
            parent = this.parent(parent);
        }
        return parent;
    }

    @Override
    public Iterator<IntCursor> iterator() {
        return this.iterator(this.first(this.root));
    }

    private Iterator<IntCursor> iterator(final int startNode) {
        return new UnmodifiableIterator<IntCursor>(){
            boolean nextSet;
            final IntCursor cursor = new IntCursor();
            {
                this.cursor.index = -1;
                this.cursor.value = startNode;
                this.nextSet = this.cursor.value != 0;
            }

            boolean computeNext() {
                if (this.cursor.value != 0) {
                    this.cursor.value = RedBlackTree.this.nextNode(this.cursor.value);
                }
                this.nextSet = this.cursor.value != 0;
                return this.nextSet;
            }

            @Override
            public boolean hasNext() {
                return this.nextSet || this.computeNext();
            }

            @Override
            public IntCursor next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.nextSet = false;
                return this.cursor;
            }
        };
    }

    public Iterator<IntCursor> reverseIterator() {
        return this.reverseIterator(this.last(this.root));
    }

    private Iterator<IntCursor> reverseIterator(final int startNode) {
        return new UnmodifiableIterator<IntCursor>(){
            boolean nextSet;
            final IntCursor cursor = new IntCursor();
            {
                this.cursor.index = -1;
                this.cursor.value = startNode;
                this.nextSet = this.cursor.value != 0;
            }

            boolean computeNext() {
                if (this.cursor.value != 0) {
                    this.cursor.value = RedBlackTree.this.prevNode(this.cursor.value);
                }
                this.nextSet = this.cursor.value != 0;
                return this.nextSet;
            }

            @Override
            public boolean hasNext() {
                return this.nextSet || this.computeNext();
            }

            @Override
            public IntCursor next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.nextSet = false;
                return this.cursor;
            }
        };
    }

    public Iterable<IntCursor> tailSet(final int startNode) {
        return new Iterable<IntCursor>(){

            @Override
            public Iterator<IntCursor> iterator() {
                return RedBlackTree.this.iterator(startNode);
            }
        };
    }

    public Iterable<IntCursor> reverseSet() {
        return new Iterable<IntCursor>(){

            @Override
            public Iterator<IntCursor> iterator() {
                return RedBlackTree.this.reverseIterator();
            }
        };
    }
}

