/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntax;

import org.apache.directory.shared.ldap.schema.syntax.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class PostalAddressSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String SC_OID = "1.3.6.1.4.1.1466.115.121.1.41";

    public PostalAddressSyntaxChecker() {
        super(SC_OID);
    }

    protected PostalAddressSyntaxChecker(String oid) {
        super(oid);
    }

    public boolean isValidSyntax(Object value) {
        if (value == null) {
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            return false;
        }
        int dollar = strValue.indexOf(36);
        if (dollar == -1) {
            return true;
        }
        int pos = 0;
        do {
            String address;
            if (StringTools.isEmpty(address = strValue.substring(pos, dollar))) {
                return false;
            }
            pos = dollar + 1;
            if (pos != strValue.length()) continue;
            return false;
        } while ((dollar = strValue.indexOf(36, pos)) > -1);
        return true;
    }
}

