/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.storage.DefaultFulltextParser;
import org.nuxeo.ecm.core.storage.FulltextParser;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.storage.binary.BinaryManager;
import org.nuxeo.ecm.core.storage.binary.BinaryManagerDescriptor;
import org.nuxeo.ecm.core.storage.binary.BinaryManagerService;
import org.nuxeo.ecm.core.storage.binary.DefaultBinaryManager;
import org.nuxeo.ecm.core.storage.lock.LockManager;
import org.nuxeo.ecm.core.storage.lock.LockManagerService;
import org.nuxeo.ecm.core.storage.sql.CachingMapper;
import org.nuxeo.ecm.core.storage.sql.InvalidationsPropagator;
import org.nuxeo.ecm.core.storage.sql.InvalidationsQueue;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelSetup;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.Repository;
import org.nuxeo.ecm.core.storage.sql.RepositoryBackend;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.SelectionContext;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;
import org.nuxeo.ecm.core.storage.sql.SoftRefCachingMapper;
import org.nuxeo.ecm.core.storage.sql.VCSLockManager;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCBackend;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;

public class RepositoryImpl
implements Repository {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RepositoryImpl.class);
    protected final RepositoryDescriptor repositoryDescriptor;
    protected final EventService eventService;
    protected final Class<? extends FulltextParser> fulltextParserClass;
    protected final BinaryManager binaryManager;
    private final RepositoryBackend backend;
    private final Collection<SessionImpl> sessions;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final Counter repositoryUp;
    protected final Counter sessionCount;
    private LockManager lockManager;
    private final InvalidationsPropagator cachePropagator;
    private final InvalidationsPropagator eventPropagator;
    private final InvalidationsQueue repositoryEventQueue;
    private Model model;
    public String repositoryId;
    private Reference reference;

    public RepositoryImpl(RepositoryDescriptor repositoryDescriptor) throws StorageException {
        Class<?> klass;
        this.repositoryDescriptor = repositoryDescriptor;
        this.sessions = new CopyOnWriteArrayList<SessionImpl>();
        this.cachePropagator = new InvalidationsPropagator("cache-" + this);
        this.eventPropagator = new InvalidationsPropagator("event-" + this);
        this.repositoryEventQueue = new InvalidationsQueue("repo-" + repositoryDescriptor.name);
        try {
            this.eventService = (EventService)Framework.getService(EventService.class);
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
        String className = repositoryDescriptor.fulltextParser;
        if (StringUtils.isBlank((String)className)) {
            className = DefaultFulltextParser.class.getName();
        }
        try {
            klass = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new StorageException("Unknown fulltext parser class: " + className, e);
        }
        if (!FulltextParser.class.isAssignableFrom(klass)) {
            throw new StorageException("Invalid fulltext parser class: " + className);
        }
        this.fulltextParserClass = klass;
        this.binaryManager = this.createBinaryManager();
        this.backend = this.createBackend();
        this.repositoryUp = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", repositoryDescriptor.name, "instance-up"}));
        this.repositoryUp.inc();
        this.sessionCount = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", repositoryDescriptor.name, "sessions"}));
        this.createMetricsGauges();
    }

    protected void createMetricsGauges() {
        String gaugeName = MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", this.repositoryDescriptor.name, "caches", "size"});
        this.registry.remove(gaugeName);
        this.registry.register(gaugeName, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return RepositoryImpl.this.getCacheSize();
            }
        });
        gaugeName = MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", this.repositoryDescriptor.name, "caches", "pristines"});
        this.registry.remove(gaugeName);
        this.registry.register(gaugeName, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return RepositoryImpl.this.getCachePristineSize();
            }
        });
        gaugeName = MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", this.repositoryDescriptor.name, "caches", "selections"});
        this.registry.remove(gaugeName);
        this.registry.register(gaugeName, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return RepositoryImpl.this.getCacheSelectionSize();
            }
        });
        gaugeName = MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", this.repositoryDescriptor.name, "caches", "mappers"});
        this.registry.remove(gaugeName);
        this.registry.register(gaugeName, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return RepositoryImpl.this.getCacheMapperSize();
            }
        });
    }

    protected BinaryManager createBinaryManager() throws StorageException {
        try {
            Class<? extends BinaryManager> klass = this.repositoryDescriptor.binaryManagerClass;
            if (klass == null) {
                klass = DefaultBinaryManager.class;
            }
            BinaryManager binaryManager = klass.newInstance();
            BinaryManagerDescriptor binaryManagerDescriptor = new BinaryManagerDescriptor();
            binaryManagerDescriptor.repositoryName = this.repositoryDescriptor.name;
            binaryManagerDescriptor.klass = klass;
            binaryManagerDescriptor.key = this.repositoryDescriptor.binaryManagerKey;
            binaryManagerDescriptor.storePath = this.repositoryDescriptor.binaryStorePath;
            binaryManager.initialize(binaryManagerDescriptor);
            BinaryManagerService bms = (BinaryManagerService)Framework.getLocalService(BinaryManagerService.class);
            bms.addBinaryManager(this.repositoryDescriptor.name, binaryManager);
            return binaryManager;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    protected RepositoryBackend createBackend() throws StorageException {
        Class<? extends RepositoryBackend> backendClass = this.repositoryDescriptor.backendClass;
        if (backendClass == null) {
            backendClass = JDBCBackend.class;
        }
        try {
            RepositoryBackend backend = backendClass.newInstance();
            backend.initialize(this);
            return backend;
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    protected Mapper createCachingMapper(Model model, Mapper mapper) throws StorageException {
        try {
            Class<? extends CachingMapper> cachingMapperClass = this.getCachingMapperClass();
            if (cachingMapperClass == null) {
                return mapper;
            }
            CachingMapper cachingMapper = cachingMapperClass.newInstance();
            cachingMapper.initialize(model, mapper, this.cachePropagator, this.eventPropagator, this.repositoryEventQueue, this.repositoryDescriptor.cachingMapperProperties);
            return cachingMapper;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    protected Class<? extends CachingMapper> getCachingMapperClass() {
        if (!this.repositoryDescriptor.getCachingMapperEnabled()) {
            return null;
        }
        Class<? extends CachingMapper> cachingMapperClass = this.repositoryDescriptor.cachingMapperClass;
        if (cachingMapperClass == null) {
            cachingMapperClass = SoftRefCachingMapper.class;
        }
        return cachingMapperClass;
    }

    public RepositoryDescriptor getRepositoryDescriptor() {
        return this.repositoryDescriptor;
    }

    public BinaryManager getBinaryManager() {
        return this.binaryManager;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public Model getModel() {
        return this.model;
    }

    public RepositoryBackend getBackend() {
        return this.backend;
    }

    public Class<? extends FulltextParser> getFulltextParserClass() {
        return this.fulltextParserClass;
    }

    @Override
    public SessionImpl getConnection(ConnectionSpec connectionSpec) throws StorageException {
        return this.getConnection();
    }

    @Override
    public synchronized SessionImpl getConnection() throws StorageException {
        if (Framework.getRuntime().isShuttingDown()) {
            throw new IllegalStateException("Cannot open connection, runtime is shutting down");
        }
        if (this.model == null) {
            this.initRepository();
        }
        SessionPathResolver pathResolver = new SessionPathResolver();
        Mapper mapper = this.backend.newMapper(this.model, pathResolver, null);
        SessionImpl session = this.newSession(this.model, mapper);
        pathResolver.setSession(session);
        this.sessions.add(session);
        this.sessionCount.inc();
        return session;
    }

    protected void initRepository() throws StorageException {
        Class<? extends CachingMapper> cachingMapperClass;
        log.debug((Object)"Initializing");
        ModelSetup modelSetup = new ModelSetup();
        modelSetup.repositoryDescriptor = this.repositoryDescriptor;
        this.backend.initializeModelSetup(modelSetup);
        this.model = new Model(modelSetup);
        this.backend.initializeModel(this.model);
        this.initLockManager();
        if (this.repositoryDescriptor.getClusteringEnabled()) {
            this.backend.newMapper(this.model, null, RepositoryBackend.MapperKind.CLUSTER_NODE_HANDLER);
            log.info((Object)("Clustering enabled with " + this.repositoryDescriptor.getClusteringDelay() + " ms delay for repository: " + this.getName()));
        }
        if ((cachingMapperClass = this.getCachingMapperClass()) == null) {
            log.warn((Object)"VCS Mapper cache is disabled.");
        } else {
            log.info((Object)("VCS Mapper cache using: " + cachingMapperClass.getName()));
        }
    }

    protected void initLockManager() throws StorageException {
        String lockManagerName = this.getName();
        LockManagerService lockManagerService = (LockManagerService)Framework.getService(LockManagerService.class);
        this.lockManager = lockManagerService.getLockManager(lockManagerName);
        if (this.lockManager == null) {
            this.lockManager = new VCSLockManager(lockManagerName);
        }
        log.info((Object)("Repository " + this.getName() + " using lock manager " + this.lockManager));
    }

    protected SessionImpl newSession(Model model, Mapper mapper) throws StorageException {
        mapper = this.createCachingMapper(model, mapper);
        return new SessionImpl(this, model, mapper);
    }

    public ResourceAdapterMetaData getMetaData() {
        throw new UnsupportedOperationException();
    }

    public RecordFactory getRecordFactory() {
        throw new UnsupportedOperationException();
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() {
        return this.reference;
    }

    @Override
    public synchronized void close() throws StorageException {
        this.closeAllSessions();
        this.model = null;
        this.backend.shutdown();
        this.binaryManager.close();
        BinaryManagerService bms = (BinaryManagerService)Framework.getLocalService(BinaryManagerService.class);
        bms.removeBinaryManager(this.repositoryDescriptor.name);
        this.registry.remove(MetricRegistry.name(RepositoryImpl.class, (String[])new String[]{this.getName(), "cache-size"}));
        this.registry.remove(MetricRegistry.name(PersistenceContext.class, (String[])new String[]{this.getName(), "cache-size"}));
        this.registry.remove(MetricRegistry.name(SelectionContext.class, (String[])new String[]{this.getName(), "cache-size"}));
    }

    protected synchronized void closeAllSessions() throws StorageException {
        for (SessionImpl session : this.sessions) {
            if (!session.isLive()) continue;
            session.closeSession();
        }
        this.sessions.clear();
        this.sessionCount.dec(this.sessionCount.getCount());
        if (this.lockManager != null) {
            this.lockManager.close();
        }
    }

    @Override
    public String getName() {
        return this.repositoryDescriptor.name;
    }

    @Override
    public int getActiveSessionsCount() {
        return this.sessions.size();
    }

    @Override
    public int clearCaches() {
        int n = 0;
        for (SessionImpl session : this.sessions) {
            n += session.clearCaches();
        }
        if (this.lockManager != null) {
            this.lockManager.clearCaches();
        }
        return n;
    }

    @Override
    public long getCacheSize() {
        long size = 0L;
        for (SessionImpl session : this.sessions) {
            size += session.getCacheSize();
        }
        return size;
    }

    public long getCacheMapperSize() {
        long size = 0L;
        for (SessionImpl session : this.sessions) {
            size += session.getCacheMapperSize();
        }
        return size;
    }

    @Override
    public long getCachePristineSize() {
        long size = 0L;
        for (SessionImpl session : this.sessions) {
            size += session.getCachePristineSize();
        }
        return size;
    }

    @Override
    public long getCacheSelectionSize() {
        long size = 0L;
        for (SessionImpl session : this.sessions) {
            size += session.getCacheSelectionSize();
        }
        return size;
    }

    @Override
    public void processClusterInvalidationsNext() {
    }

    @Override
    public BinaryGarbageCollector getBinaryGarbageCollector() {
        return this.binaryManager.getGarbageCollector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markReferencedBinaries(BinaryGarbageCollector gc) {
        try (SessionImpl conn = this.getConnection();){
            conn.markReferencedBinaries(gc);
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cleanupDeletedDocuments(int max, Calendar beforeTime) {
        int n;
        if (!this.repositoryDescriptor.getSoftDeleteEnabled()) {
            return 0;
        }
        SessionImpl conn = this.getConnection();
        try {
            n = conn.cleanupDeletedDocuments(max, beforeTime);
        }
        catch (Throwable throwable) {
            try {
                conn.close();
                throw throwable;
            }
            catch (ResourceException e) {
                throw new RuntimeException(e);
            }
        }
        conn.close();
        return n;
    }

    protected void closeSession(SessionImpl session) {
        this.sessions.remove(session);
        this.sessionCount.dec();
    }

    public static class SessionPathResolver
    implements Session.PathResolver {
        private Session session;

        protected void setSession(Session session) {
            this.session = session;
        }

        @Override
        public Serializable getIdForPath(String path) throws StorageException {
            Node node = this.session.getNodeByPath(path, null);
            return node == null ? null : node.getId();
        }
    }
}

