/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.multi;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.directory.PermissionDescriptor;
import org.nuxeo.ecm.directory.multi.SourceDescriptor;

@XObject(value="directory")
public class MultiDirectoryDescriptor
implements Cloneable {
    @XNode(value="@name")
    public String name;
    @XNode(value="schema")
    protected String schemaName;
    @XNode(value="idField")
    protected String idField;
    @XNode(value="passwordField")
    protected String passwordField;
    @XNode(value="readOnly")
    public Boolean readOnly;
    @XNode(value="querySizeLimit")
    public Integer querySizeLimit;
    @XNode(value="@remove")
    public boolean remove = false;
    @XNodeList(value="source", type=SourceDescriptor[].class, componentType=SourceDescriptor.class)
    protected SourceDescriptor[] sources;
    @XNodeList(value="permissions/permission", type=PermissionDescriptor[].class, componentType=PermissionDescriptor.class)
    public PermissionDescriptor[] permissions = null;

    public void merge(MultiDirectoryDescriptor other) {
        this.merge(other, false);
    }

    public void merge(MultiDirectoryDescriptor other, boolean overwrite) {
        if (other.schemaName != null || overwrite) {
            this.schemaName = other.schemaName;
        }
        if (other.idField != null || overwrite) {
            this.idField = other.idField;
        }
        if (other.passwordField != null || overwrite) {
            this.passwordField = other.passwordField;
        }
        if (other.readOnly != null || overwrite) {
            this.readOnly = other.readOnly;
        }
        if (other.querySizeLimit != null || overwrite) {
            this.querySizeLimit = other.querySizeLimit;
        }
        if (other.sources != null || overwrite) {
            if (this.sources == null) {
                this.sources = other.sources;
            } else {
                SourceDescriptor[] s = new SourceDescriptor[this.sources.length + other.sources.length];
                System.arraycopy(this.sources, 0, s, 0, this.sources.length);
                System.arraycopy(other.sources, 0, s, this.sources.length, other.sources.length);
                this.sources = s;
            }
        }
        if (other.permissions != null && other.permissions.length != 0 || overwrite) {
            this.permissions = other.permissions;
        }
    }

    public MultiDirectoryDescriptor clone() {
        int i;
        MultiDirectoryDescriptor clone = new MultiDirectoryDescriptor();
        clone.name = this.name;
        clone.schemaName = this.schemaName;
        clone.idField = this.idField;
        clone.passwordField = this.passwordField;
        clone.readOnly = this.readOnly;
        clone.querySizeLimit = this.querySizeLimit;
        clone.remove = this.remove;
        if (this.sources != null) {
            clone.sources = new SourceDescriptor[this.sources.length];
            for (i = 0; i < this.sources.length; ++i) {
                clone.sources[i] = this.sources[i].clone();
            }
        }
        if (this.permissions != null) {
            clone.permissions = new PermissionDescriptor[this.permissions.length];
            for (i = 0; i < this.permissions.length; ++i) {
                clone.permissions[i] = this.permissions[i].clone();
            }
        }
        return clone;
    }
}

