/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme;

import java.io.InputStream;
import java.net.URL;

public class ResourceResolver {
    private static final ResourceResolver DEFAULT;
    private static ResourceResolver instance;

    public static ResourceResolver getInstance() {
        return instance;
    }

    public static void setInstance(ResourceResolver resolver) {
        instance = resolver == null ? DEFAULT : resolver;
    }

    public URL getResource(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource(path);
        if (url == null) {
            url = cl.getResource("nuxeo.war/" + path);
        }
        return url;
    }

    public InputStream getResourceAsStream(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream(path);
        if (is == null) {
            is = cl.getResourceAsStream("nuxeo.war/" + path);
        }
        return is;
    }

    static {
        instance = DEFAULT = new ResourceResolver();
    }
}

