/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme;

import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSDeclaration;
import com.phloc.css.decl.CSSSelector;
import com.phloc.css.decl.CSSStyleRule;
import com.phloc.css.decl.CascadingStyleSheet;
import com.phloc.css.reader.CSSReader;
import com.phloc.css.writer.CSSWriterSettings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.theme.ResourceResolver;
import org.nuxeo.theme.formats.styles.Style;

public final class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);
    private static final String EMPTY_CSS_SELECTOR = "EMPTY";
    private static final Pattern emptyCssSelectorPattern = Pattern.compile("(.*?)\\{(.*?)\\}", 32);

    private Utils() {
    }

    public static String listToCsv(List<String> list) {
        StringWriter sw = new StringWriter();
        try (CSVPrinter writer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withDelimiter(',').withQuoteMode(QuoteMode.ALL));){
            writer.printRecord(list);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sw.toString();
    }

    public static List<String> csvToList(String str) throws IOException {
        if ("".equals(str) || str == null) {
            return new ArrayList<String>();
        }
        StringReader sr = new StringReader(str);
        try (CSVParser reader = new CSVParser((Reader)sr, CSVFormat.DEFAULT.withDelimiter(','));){
            Iterator iterator = reader.iterator();
            if (!iterator.hasNext()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                return arrayList;
            }
            CSVRecord nextRecord = (CSVRecord)iterator.next();
            ArrayList<String> result = new ArrayList<String>(nextRecord.size());
            for (String value : nextRecord) {
                result.add(value);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    public static boolean contains(String[] array, String value) {
        for (String s : array) {
            if (!s.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static String cleanUp(String text) {
        return text.replaceAll("\n", " ").replaceAll("\\t+", " ").replaceAll("\\s+", " ").trim();
    }

    public static byte[] readResourceAsBytes(String path) throws IOException {
        return Utils.readResource(path).toByteArray();
    }

    public static String readResourceAsString(String path) throws IOException {
        return Utils.readResource(path).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteArrayOutputStream readResource(String path) throws IOException {
        ByteArrayOutputStream os;
        block15: {
            InputStream is = null;
            os = null;
            try {
                is = ResourceResolver.getInstance().getResourceAsStream(path);
                if (is == null) {
                    log.warn((Object)("Resource not found: " + path));
                    break block15;
                }
                try {
                    int i;
                    os = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((i = is.read(buffer)) != -1) {
                        os.write(buffer, 0, i);
                    }
                    os.flush();
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    finally {
                        is = null;
                    }
                }
            }
        }
        return os;
    }

    public static byte[] fetchUrl(URL url) {
        byte[] data = null;
        try {
            int i;
            InputStream in = url.openStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((i = in.read(buffer)) != -1) {
                os.write(buffer, 0, i);
            }
            data = os.toByteArray();
            in.close();
            os.close();
        }
        catch (IOException e) {
            log.error((Object)("Could not retrieve URL: " + url.toString()));
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeFile(URL url, String text) throws IOException {
        if (url.getProtocol().equals("file")) {
            String filepath = url.getFile();
            File file = new File(filepath);
            FileUtils.writeFile((File)file, (String)text);
            return;
        }
        OutputStream os = null;
        try {
            URLConnection urlc = url.openConnection();
            os = urlc.getOutputStream();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (os == null) return;
        try {
            os.write(text.getBytes());
            os.flush();
            return;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            try {
                try {
                    os.close();
                    os = null;
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    os = null;
                }
            }
            catch (Throwable throwable) {
                os = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties(Properties properties, String resourceName) {
        if (properties.isEmpty()) {
            InputStream in = null;
            try {
                in = Utils.class.getResourceAsStream(resourceName);
                if (in != null) {
                    properties.load(in);
                }
            }
            catch (IOException e) {
                log.error((Object)"Could not load properties", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Failed to close stream", (Throwable)e);
                    }
                }
            }
        }
    }

    public static void loadCss(Style style, String cssSource, String viewName, boolean merge) {
        cssSource = cssSource.replaceAll("\\$\\{basePath\\}", "TEMPORARY_BASE_PATH_MARKER");
        Matcher matcher = emptyCssSelectorPattern.matcher(cssSource);
        StringBuilder buf = new StringBuilder();
        while (matcher.find()) {
            if (matcher.group(1).trim().equals("")) {
                buf.append(EMPTY_CSS_SELECTOR);
            }
            buf.append(matcher.group(0));
        }
        cssSource = buf.toString();
        CascadingStyleSheet styleSheet = CSSReader.readFromString((String)(cssSource = cssSource.replaceAll("TEMPORARY_BASE_PATH_MARKER", "\\$\\{basePath\\}")), (String)"utf-8", (ECSSVersion)ECSSVersion.CSS30);
        if (styleSheet == null) {
            log.error((Object)("Could not parse CSS:\n" + cssSource));
            return;
        }
        if (!merge) {
            style.clearPropertiesFor(viewName);
        }
        CSSWriterSettings writerSettings = new CSSWriterSettings(ECSSVersion.CSS30, true);
        for (CSSStyleRule rule : styleSheet.getAllStyleRules()) {
            Properties properties = new Properties();
            for (CSSDeclaration declaration : rule.getAllDeclarations()) {
                String expression = declaration.getExpression().getAsCSSString((ICSSWriterSettings)writerSettings, 0);
                if (declaration.isImportant()) {
                    expression = expression + " !important";
                }
                properties.put(declaration.getProperty(), expression);
            }
            for (CSSSelector cssSelector : rule.getAllSelectors()) {
                String selector = cssSelector.getAsCSSString((ICSSWriterSettings)writerSettings, 0);
                if (selector.equals(EMPTY_CSS_SELECTOR) || selector.toLowerCase().equals("body") || selector.toLowerCase().equals("html")) {
                    selector = "";
                }
                style.setPropertiesFor(viewName, selector, properties);
            }
        }
    }

    public static void loadCss(Style style, String cssSource, String viewName) {
        Utils.loadCss(style, cssSource, viewName, false);
    }
}

