/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.uids;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.nuxeo.theme.Registrable;
import org.nuxeo.theme.uids.Identifiable;

public final class UidManager
implements Registrable {
    private final Map<Integer, Identifiable> registry = new HashMap<Integer, Identifiable>();

    public Object getObjectByUid(Integer uid) {
        return this.registry.get(uid);
    }

    public synchronized int register(Identifiable object) {
        int uid = this.getFreeUid();
        this.registry.put(uid, object);
        object.setUid(uid);
        return uid;
    }

    public synchronized void unregister(Identifiable object) {
        int uid = object.getUid();
        this.registry.remove(uid);
        object.setUid(null);
    }

    private synchronized int getFreeUid() {
        int uid;
        Random generator = new Random();
        generator.setSeed(0L);
        while ((uid = generator.nextInt()) <= 0 || this.registry.containsKey(uid)) {
        }
        return uid;
    }

    @Override
    public synchronized void clear() {
        ArrayList<Identifiable> objects = new ArrayList<Identifiable>();
        for (Identifiable o : this.registry.values()) {
            objects.add(o);
        }
        for (Identifiable o : objects) {
            this.unregister(o);
        }
        objects = null;
        this.registry.clear();
    }

    public Collection<Integer> listUids() {
        return this.registry.keySet();
    }
}

