/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf;

import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;

public final class URLUtils {
    private static final Log log = LogFactory.getLog(URLUtils.class);

    private URLUtils() {
    }

    public static String getServerURL() {
        return URLUtils.getServerURL(null);
    }

    public static String getServerURL(ServletRequest request) {
        if (request == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            request = (ServletRequest)facesContext.getExternalContext().getRequest();
        }
        return VirtualHostHelper.getServerURL((ServletRequest)request);
    }

    public static String getWebAppName() {
        return BaseURL.getWebAppName();
    }

    public static String getBaseURL() {
        return URLUtils.getBaseURL(null);
    }

    public static String getBaseURL(ServletRequest request) {
        String baseURL = null;
        String serverUrl = URLUtils.getServerURL(request);
        if (serverUrl != null) {
            baseURL = serverUrl + URLUtils.getWebAppName() + '/';
        }
        if (baseURL == null) {
            log.error((Object)"Could not retrieve base url correctly");
        }
        return baseURL;
    }
}

