/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.servlet.AbstractHTTPServlet;
import org.apache.cxf.transport.servlet.ServletContextResourceResolver;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.servicelist.ServiceListGeneratorServlet;

public class CXFNonSpringServlet
extends AbstractHTTPServlet {
    private static final long serialVersionUID = -2437897227486327166L;
    private DestinationRegistry destinationRegistry;
    private boolean globalRegistry;
    private Bus bus;
    private ServletController controller;
    private ClassLoader loader;
    private boolean loadBus = true;

    public CXFNonSpringServlet() {
    }

    public CXFNonSpringServlet(DestinationRegistry destinationRegistry) {
        this(destinationRegistry, true);
    }

    public CXFNonSpringServlet(DestinationRegistry destinationRegistry, boolean loadBus) {
        this.destinationRegistry = destinationRegistry;
        this.globalRegistry = destinationRegistry != null;
        this.loadBus = loadBus;
    }

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        if (this.bus == null && this.loadBus) {
            this.loadBus(sc);
        }
        if (this.bus != null) {
            this.loader = (ClassLoader)this.bus.getExtension(ClassLoader.class);
            ResourceManager resourceManager = (ResourceManager)this.bus.getExtension(ResourceManager.class);
            resourceManager.addResourceResolver((ResourceResolver)new ServletContextResourceResolver(sc.getServletContext()));
            if (this.destinationRegistry == null) {
                this.destinationRegistry = CXFNonSpringServlet.getDestinationRegistryFromBus(this.bus);
            }
        }
        this.controller = this.createServletController(sc);
    }

    private static DestinationRegistry getDestinationRegistryFromBus(Bus bus) {
        DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        try {
            DestinationFactory df = dfm.getDestinationFactory("http://cxf.apache.org/transports/http/configuration");
            if (df instanceof HTTPTransportFactory) {
                HTTPTransportFactory transportFactory = (HTTPTransportFactory)df;
                return transportFactory.getRegistry();
            }
        }
        catch (BusException busException) {
            // empty catch block
        }
        return null;
    }

    protected void loadBus(ServletConfig sc) {
        this.bus = BusFactory.newInstance().createBus();
    }

    private ServletController createServletController(ServletConfig servletConfig) {
        ServiceListGeneratorServlet serviceListGeneratorServlet = new ServiceListGeneratorServlet(this.destinationRegistry, this.bus);
        ServletController newController = new ServletController(this.destinationRegistry, servletConfig, serviceListGeneratorServlet);
        return newController;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invoke(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ClassLoaderUtils.ClassLoaderHolder origLoader = null;
        Bus origBus = null;
        try {
            if (this.loader != null) {
                origLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)this.loader);
            }
            if (this.bus != null) {
                origBus = BusFactory.getAndSetThreadDefaultBus((Bus)this.bus);
            }
            this.controller.invoke(request, response);
        }
        finally {
            if (origBus != this.bus) {
                BusFactory.setThreadDefaultBus(null);
            }
            if (origLoader != null) {
                origLoader.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (!this.globalRegistry) {
            for (String path : this.destinationRegistry.getDestinationsPaths()) {
                AbstractHTTPDestination dest;
                AbstractHTTPDestination abstractHTTPDestination = dest = this.destinationRegistry.getDestinationForPath(path);
                synchronized (abstractHTTPDestination) {
                    this.destinationRegistry.removeDestination(path);
                    dest.releaseRegistry();
                }
            }
            this.destinationRegistry = null;
        }
        this.destroyBus();
    }

    public void destroyBus() {
        if (this.bus != null) {
            this.bus.shutdown(true);
            this.bus = null;
        }
    }
}

