/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.RedisHostDescriptor;
import org.nuxeo.ecm.core.redis.RedisPoolDescriptor;
import org.nuxeo.ecm.core.redis.RedisPoolExecutor;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.util.Pool;

@XObject(value="server")
public class RedisServerDescriptor
extends RedisPoolDescriptor {
    private static final Log log = LogFactory.getLog(RedisServerDescriptor.class);
    @XNode(value="hosts")
    public RedisHostDescriptor[] hosts = new RedisHostDescriptor[0];

    @XNode(value="host")
    public void setHost(String name) {
        if (this.hosts.length == 0) {
            this.hosts = new RedisHostDescriptor[]{new RedisHostDescriptor(name, 6379)};
        } else {
            this.hosts[0].name = name;
        }
    }

    @XNode(value="port")
    public void setHost(int port) {
        if (this.hosts.length == 0) {
            this.hosts = new RedisHostDescriptor[]{new RedisHostDescriptor("localhost", port)};
        } else {
            this.hosts[0].port = port;
        }
    }

    public RedisHostDescriptor selectHost() {
        for (RedisHostDescriptor host : this.hosts) {
            if (!this.canConnect(host.name, host.port)) continue;
            return host;
        }
        throw new NuxeoException("Cannot connect to jedis hosts");
    }

    protected boolean canConnect(String name, int port) {
        try (Jedis jedis = new Jedis(name, port);){
            if (StringUtils.isNotBlank((String)this.password)) {
                jedis.auth(this.password);
            }
            boolean bl = this.canPing(jedis);
            return bl;
        }
    }

    protected boolean canPing(Jedis jedis) {
        try {
            String pong = jedis.ping();
            return "PONG".equals(pong);
        }
        catch (Exception cause) {
            log.debug((Object)"Exception during ping", (Throwable)cause);
            return false;
        }
    }

    @Override
    public RedisExecutor newExecutor() {
        if (this.hosts.length == 0) {
            throw new RuntimeException("Missing Redis host");
        }
        if (this.hosts.length > 1) {
            throw new RuntimeException("Only one host supported");
        }
        RedisHostDescriptor host = this.selectHost();
        return new RedisPoolExecutor((Pool<Jedis>)new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), host.name, host.port, this.timeout, StringUtils.defaultIfBlank((String)this.password, null), this.database));
    }
}

