/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.resultset.OutputBase;
import com.hp.hpl.jena.util.FileUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.openjena.atlas.lib.StrUtils;

public class CSVOutput
extends OutputBase {
    static String NL = "\r\n";
    static final byte[] yesBytes = StrUtils.asUTF8bytes("yes");
    static final byte[] noBytes = StrUtils.asUTF8bytes("no");
    static final byte[] NLBytes = StrUtils.asUTF8bytes(NL);

    public void format(OutputStream out, ResultSet resultSet) {
        try {
            Writer w = FileUtils.asUTF8((OutputStream)out);
            w = new BufferedWriter(w);
            String sep = null;
            List<String> varNames = resultSet.getResultVars();
            ArrayList<Var> vars = new ArrayList<Var>(varNames.size());
            for (String v : varNames) {
                if (sep != null) {
                    w.write(sep);
                } else {
                    sep = ",";
                }
                w.write(this.csvSafe(v));
                vars.add(Var.alloc(v));
            }
            w.write(NL);
            while (resultSet.hasNext()) {
                sep = null;
                Binding b = resultSet.nextBinding();
                for (Var v : vars) {
                    if (sep != null) {
                        w.write(sep);
                    }
                    sep = ",";
                    Node n = b.get(v);
                    if (n == null) continue;
                    this.output(w, n);
                }
                w.write(NL);
            }
            w.flush();
        }
        catch (IOException ex) {
            throw new ARQException(ex);
        }
    }

    private void output(Writer w, Node n) throws IOException {
        String str2 = "?";
        if (n.isLiteral()) {
            str2 = n.getLiteralLexicalForm();
        } else if (n.isURI()) {
            str2 = n.getURI();
        } else if (n.isBlank()) {
            str2 = n.getBlankNodeLabel();
        }
        str2 = this.csvSafe(str2);
        w.write(str2);
    }

    private String csvSafe(String str2) {
        if (str2.contains("\"") || str2.contains(",") || str2.contains("\r") || str2.contains("\n")) {
            str2 = "\"" + str2.replaceAll("\"", "\"\"") + "\"";
        }
        return str2;
    }

    public void format(OutputStream out, boolean booleanResult) {
        try {
            if (booleanResult) {
                out.write(yesBytes);
            } else {
                out.write(noBytes);
            }
            out.write(NLBytes);
        }
        catch (IOException ex) {
            throw new ARQException(ex);
        }
    }
}

