/*
 * Decompiled with CFR 0.152.
 */
package com.cforcoding.jmd;

import com.cforcoding.jmd.urlvalidator.JreUrlValidator;
import com.cforcoding.jmd.urlvalidator.UrlValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlSanitizer {
    public static UrlValidator urlValidator = new JreUrlValidator();
    public static Pattern forbiddenTags = Pattern.compile("^(script|object|embed|link|style|form|input)$");
    public static Pattern allowedTags = Pattern.compile("^(b|p|i|s|a|img|table|thead|tbody|tfoot|tr|th|td|dd|dl|dt|em|h1|h2|h3|h4|h5|h6|li|ul|ol|span|div|strike|strong|sub|sup|pre|del|code|blockquote|strike|kbd|br|hr|area|map|object|embed|param|link|form|small|big)$");
    private static Pattern commentPattern = Pattern.compile("<!--.*");
    private static Pattern tagStartPattern = Pattern.compile("<(?i)(\\w+\\b)\\s*(.*)/?>$");
    private static Pattern tagClosePattern = Pattern.compile("</(?i)(\\w+\\b)\\s*>$");
    private static Pattern standAloneTags = Pattern.compile("^(img|br|hr)$");
    private static Pattern selfClosed = Pattern.compile("<.+/>");
    private static Pattern attributesPattern = Pattern.compile("(\\w*)\\s*=\\s*\"([^\"]*)\"");
    private static Pattern stylePattern = Pattern.compile("([^\\s^:]+)\\s*:\\s*([^;]+);?");
    private static Pattern urlStylePattern = Pattern.compile("(?i).*\\b\\s*url\\s*\\(['\"]([^)]*)['\"]\\)");
    public static Pattern forbiddenStylePattern = Pattern.compile("(?:(expression|eval|javascript))\\s*\\(");

    HtmlSanitizer() {
    }

    public static boolean isSanitized(String html) {
        return HtmlSanitizer.sanitizer((String)html).isValid;
    }

    public static String sanitize(String html) {
        return HtmlSanitizer.sanitizer((String)html).html;
    }

    public static String getText(String html) {
        return HtmlSanitizer.sanitizer((String)html).text;
    }

    public static SanitizeResult sanitizer(String html) {
        return HtmlSanitizer.sanitizer(html, allowedTags, forbiddenTags);
    }

    /*
     * Unable to fully structure code
     */
    public static SanitizeResult sanitizer(String html, Pattern allowedTags, Pattern forbiddenTags) {
        ret = new SanitizeResult();
        openTags = new Stack<String>();
        tokens = HtmlSanitizer.tokenize(html);
        for (String token : tokens) {
            isAcceptedToken = false;
            startMatcher = HtmlSanitizer.tagStartPattern.matcher(token);
            endMatcher = HtmlSanitizer.tagClosePattern.matcher(token);
            if (HtmlSanitizer.commentPattern.matcher(token).find()) {
                ret.val = String.valueOf(ret.val) + token + (token.endsWith("-->") != false ? "" : "-->");
                ret.invalidTags.add(String.valueOf(token) + (token.endsWith("-->") != false ? "" : "-->"));
                continue;
            }
            if (!startMatcher.find()) ** GOTO lbl112
            tag = startMatcher.group(1).toLowerCase();
            if (forbiddenTags.matcher(tag).find()) {
                ret.invalidTags.add("<" + tag + ">");
                continue;
            }
            if (allowedTags.matcher(tag).find()) {
                cleanToken = "<" + tag;
                tokenBody = startMatcher.group(2);
                if ("thead".equals(tag) || "tbody".equals(tag) || "tfoot".equals(tag) || "tr".equals(tag)) {
                    if (openTags.search("table") < 1) {
                        ret.invalidTags.add("<" + tag + ">");
                        continue;
                    }
                } else if (("td".equals(tag) || "th".equals(tag)) && openTags.search("tr") < 1) {
                    ret.invalidTags.add("<" + tag + ">");
                    continue;
                }
                attributes = HtmlSanitizer.attributesPattern.matcher(tokenBody);
                foundURL = false;
                while (attributes.find()) {
                    attr = attributes.group(1).toLowerCase();
                    val = attributes.group(2);
                    if ("a".equals(tag) && "href".equals(attr)) {
                        if (HtmlSanitizer.urlValidator.isValid(val)) {
                            foundURL = true;
                        } else if (val.toLowerCase().startsWith("mailto:") && val.indexOf("@") >= 0) {
                            val1 = "http://www." + val.substring(val.indexOf("@") + 1);
                            if (HtmlSanitizer.urlValidator.isValid(val1)) {
                                foundURL = true;
                            } else {
                                ret.invalidTags.add(String.valueOf(attr) + " " + val);
                                val = "";
                            }
                        } else {
                            ret.invalidTags.add(String.valueOf(attr) + " " + val);
                            val = "";
                        }
                    } else if (tag.matches("img|embed") && "src".equals(attr)) {
                        if (HtmlSanitizer.urlValidator.isValid(val)) {
                            foundURL = true;
                        } else {
                            ret.invalidTags.add(String.valueOf(attr) + " " + val);
                            val = "";
                        }
                    } else {
                        if ("href".equals(attr) || "src".equals(attr)) {
                            ret.invalidTags.add(String.valueOf(tag) + " " + attr + " " + val);
                            continue;
                        }
                        if (attr.matches("width|height")) {
                            if (!val.toLowerCase().matches("\\d+%|\\d+$")) {
                                ret.invalidTags.add(String.valueOf(tag) + " " + attr + " " + val);
                                continue;
                            }
                        } else if ("style".equals(attr)) {
                            styles = HtmlSanitizer.stylePattern.matcher(val);
                            cleanStyle = "";
                            while (styles.find()) {
                                styleName = styles.group(1).toLowerCase();
                                styleValue = styles.group(2);
                                if (HtmlSanitizer.forbiddenStylePattern.matcher(styleValue).find()) {
                                    ret.invalidTags.add(String.valueOf(tag) + " " + attr + " " + styleValue);
                                    continue;
                                }
                                urlStyleMatcher = HtmlSanitizer.urlStylePattern.matcher(styleValue);
                                if (urlStyleMatcher.find() && !HtmlSanitizer.urlValidator.isValid(url = urlStyleMatcher.group(1))) {
                                    ret.invalidTags.add(String.valueOf(tag) + " " + attr + " " + styleValue);
                                    continue;
                                }
                                cleanStyle = String.valueOf(cleanStyle) + styleName + ":" + HtmlSanitizer.encode(styleValue) + ";";
                            }
                            val = cleanStyle;
                        } else {
                            if (attr.startsWith("on")) {
                                ret.invalidTags.add(String.valueOf(tag) + " " + attr + " " + val);
                                continue;
                            }
                            val = HtmlSanitizer.encode(val);
                        }
                    }
                    cleanToken = String.valueOf(cleanToken) + " " + attr + "=\"" + val + "\"";
                }
                cleanToken = String.valueOf(cleanToken) + ">";
                isAcceptedToken = true;
                if (tag.matches("a|img|embed") && !foundURL) {
                    isAcceptedToken = false;
                    cleanToken = "";
                }
                token = cleanToken;
                if (isAcceptedToken && !HtmlSanitizer.standAloneTags.matcher(tag).find() && !HtmlSanitizer.selfClosed.matcher(tag).find()) {
                    openTags.push(tag);
                }
            } else {
                ret.invalidTags.add(token);
                ret.val = String.valueOf(ret.val) + token;
                continue;
lbl112:
                // 1 sources

                if (endMatcher.find()) {
                    tag = endMatcher.group(1).toLowerCase();
                    if (HtmlSanitizer.selfClosed.matcher(tag).find()) {
                        ret.invalidTags.add(token);
                        continue;
                    }
                    if (forbiddenTags.matcher(tag).find()) {
                        ret.invalidTags.add("/" + tag);
                        continue;
                    }
                    if (!allowedTags.matcher(tag).find()) {
                        ret.invalidTags.add(token);
                        ret.val = String.valueOf(ret.val) + token;
                        continue;
                    }
                    cleanToken = "";
                    pos = openTags.search(tag);
                    i = 1;
                    while (i <= pos) {
                        poppedTag = (String)openTags.pop();
                        cleanToken = String.valueOf(cleanToken) + "</" + poppedTag + ">";
                        isAcceptedToken = true;
                        ++i;
                    }
                    token = cleanToken;
                }
            }
            ret.val = String.valueOf(ret.val) + token;
            if (isAcceptedToken) {
                ret.html = String.valueOf(ret.html) + token;
                continue;
            }
            sanToken = HtmlSanitizer.htmlEncodeApexesAndTags(token);
            ret.html = String.valueOf(ret.html) + sanToken;
            ret.text = String.valueOf(ret.text) + HtmlSanitizer.htmlEncodeApexesAndTags(HtmlSanitizer.removeLineFeed(token));
        }
        while (openTags.size() > 0) {
            poppedTag = (String)openTags.pop();
            ret.html = String.valueOf(ret.html) + "</" + poppedTag + ">";
            ret.val = String.valueOf(ret.val) + "</" + poppedTag + ">";
        }
        ret.isValid = ret.invalidTags.size() == 0;
        return ret;
    }

    private static List<String> tokenize(String html) {
        ArrayList<String> tokens = new ArrayList<String>();
        int pos = 0;
        String token = "";
        int len = html.length();
        while (pos < len) {
            int end;
            char c = html.charAt(pos);
            String ahead = html.substring(pos, pos > len - 4 ? len : pos + 4);
            if ("<!--".equals(ahead)) {
                if (token.length() > 0) {
                    tokens.add(token);
                }
                token = "";
                end = HtmlSanitizer.moveToMarkerEnd(pos, "-->", html);
                tokens.add(html.substring(pos, end));
                pos = end;
                continue;
            }
            if ('<' == c) {
                if (token.length() > 0) {
                    tokens.add(token);
                }
                token = "";
                end = HtmlSanitizer.moveToMarkerEnd(pos, ">", html);
                tokens.add(html.substring(pos, end));
                pos = end;
                continue;
            }
            token = String.valueOf(token) + c;
            ++pos;
        }
        if (token.length() > 0) {
            tokens.add(token);
        }
        return tokens;
    }

    private static int moveToMarkerEnd(int pos, String marker, String s) {
        int i = s.indexOf(marker, pos);
        pos = i > -1 ? i + marker.length() : s.length();
        return pos;
    }

    public static String encode(String s) {
        return HtmlSanitizer.convertLineFeedToBR(HtmlSanitizer.htmlEncodeApexesAndTags(s == null ? "" : s));
    }

    public static final String htmlEncodeApexesAndTags(String source) {
        return HtmlSanitizer.htmlEncodeTag(HtmlSanitizer.htmlEncodeApexes(source));
    }

    public static final String htmlEncodeApexes(String source) {
        if (source != null) {
            String result = HtmlSanitizer.replaceAllNoRegex(source, new String[]{"\"", "'"}, new String[]{"&quot;", "&#39;"});
            return result;
        }
        return null;
    }

    public static final String htmlEncodeTag(String source) {
        if (source != null) {
            String result = HtmlSanitizer.replaceAllNoRegex(source, new String[]{"<", ">"}, new String[]{"&lt;", "&gt;"});
            return result;
        }
        return null;
    }

    public static String convertLineFeedToBR(String text) {
        if (text != null) {
            return HtmlSanitizer.replaceAllNoRegex(text, new String[]{"\n", "\f", "\r"}, new String[]{"<br>", "<br>", " "});
        }
        return null;
    }

    public static String removeLineFeed(String text) {
        if (text != null) {
            return HtmlSanitizer.replaceAllNoRegex(text, new String[]{"\n", "\f", "\r"}, new String[]{" ", " ", " "});
        }
        return null;
    }

    public static final String replaceAllNoRegex(String source, String[] searches, String[] replaces) {
        String tmp = source;
        int k = 0;
        while (k < searches.length) {
            tmp = HtmlSanitizer.replaceAllNoRegex(tmp, searches[k], replaces[k]);
            ++k;
        }
        return tmp;
    }

    public static final String replaceAllNoRegex(String source, String search, String replace) {
        StringBuffer buffer = new StringBuffer();
        if (source != null) {
            if (search.length() == 0) {
                return source;
            }
            int oldPos = 0;
            int pos = source.indexOf(search, oldPos);
            while (pos != -1) {
                buffer.append(source.substring(oldPos, pos));
                buffer.append(replace);
                oldPos = pos + search.length();
                pos = source.indexOf(search, oldPos);
            }
            if (oldPos < source.length()) {
                buffer.append(source.substring(oldPos));
            }
        }
        return new String(buffer);
    }

    public static class SanitizeResult {
        public String html = "";
        public String text = "";
        public String val = "";
        public boolean isValid = true;
        public List<String> invalidTags = new ArrayList<String>();
    }
}

