/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.config;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="elasticSearchIndex")
public class ElasticSearchIndexConfig {
    @XNode(value="@enabled")
    protected boolean isEnabled = true;
    @XNode(value="@name")
    protected String name;
    @XNode(value="@repository")
    protected String repositoryName = "default";
    @XNode(value="@type")
    protected String type = "doc";
    @XNode(value="@create")
    protected boolean create = true;
    @XNode(value="settings")
    protected String settings;
    public static final String DEFAULT_SETTING = "{\n   \"number_of_shards\" : 1,\n   \"number_of_replicas\" : 0,\n   \"analysis\" : {\n      \"filter\" : {\n         \"en_stem_filter\" : {\n            \"name\" : \"minimal_english\",\n            \"type\" : \"stemmer\"\n         },\n         \"en_stop_filter\" : {\n            \"stopwords\" : [\n               \"_english_\"\n            ],\n            \"type\" : \"stop\"\n         }\n      },\n      \"tokenizer\" : {\n         \"path_tokenizer\" : {\n            \"delimiter\" : \"/\",\n            \"type\" : \"path_hierarchy\"\n         }\n      },\n      \"analyzer\" : {\n         \"en_analyzer\" : {\n            \"alias\" : \"fulltext\",\n            \"filter\" : [\n               \"lowercase\",\n               \"en_stop_filter\",\n               \"en_stem_filter\",\n               \"asciifolding\"\n            ],\n            \"type\" : \"custom\",\n            \"tokenizer\" : \"standard\"\n         },\n         \"path_analyzer\" : {\n            \"type\" : \"custom\",\n            \"tokenizer\" : \"path_tokenizer\"\n         },\n         \"default\" : {\n            \"type\" : \"custom\",\n            \"tokenizer\" : \"keyword\"\n         }\n      }\n   }\n}";
    @XNode(value="mapping")
    protected String mapping;
    public static final String DEFAULT_MAPPING = "{\n   \"_all\" : {\n      \"analyzer\" : \"fulltext\"\n   },\n   \"properties\" : {\n      \"dc:title\" : {\n         \"type\" : \"multi_field\",\n         \"fields\" : {\n           \"dc:title\" : {\n             \"index\" : \"not_analyzed\",\n             \"type\" : \"string\"\n           },\n           \"fulltext\" : {\n             \"boost\": 2,\n             \"type\": \"string\",\n             \"analyzer\" : \"fulltext\"\n          }\n        }\n      },\n      \"dc:description\" : {\n         \"type\" : \"multi_field\",\n         \"fields\" : {\n           \"dc:description\" : {\n             \"index\" : \"not_analyzed\",\n             \"type\" : \"string\"\n           },\n           \"fulltext\" : {\n             \"boost\": 1.5,\n             \"type\": \"string\",\n             \"analyzer\" : \"fulltext\"\n          }\n        }\n      },\n      \"ecm:binarytext\" : {\n         \"type\" : \"string\",\n         \"index\" : \"no\",\n         \"include_in_all\" : true\n      },\n      \"ecm:path\" : {\n         \"type\" : \"multi_field\",\n         \"fields\" : {\n            \"children\" : {\n               \"search_analyzer\" : \"keyword\",\n               \"index_analyzer\" : \"path_analyzer\",\n               \"type\" : \"string\"\n            },\n            \"ecm:path\" : {\n               \"index\" : \"not_analyzed\",\n               \"type\" : \"string\"\n            }\n         }\n      },\n      \"dc:created\": {\n         \"format\": \"dateOptionalTime\",\n        \"type\": \"date\"\n      },\n      \"dc:modified\": {\n         \"format\": \"dateOptionalTime\",\n        \"type\": \"date\"\n      },\n      \"ecm:pos*\" : {\n         \"type\" : \"integer\"\n      }\n   }\n}";
    @XNodeList(value="fetchFromSource/exclude", type=String[].class, componentType=String.class)
    protected String[] excludes;
    @XNodeList(value="fetchFromSource/include", type=String[].class, componentType=String.class)
    protected String[] includes;

    public String toString() {
        if (this.isEnabled()) {
            return String.format("EsIndexConfig(%s, %s, %s)", this.getName(), this.getRepositoryName(), this.getType());
        }
        return "EsIndexConfig disabled";
    }

    public String[] getExcludes() {
        if (this.excludes == null) {
            return new String[]{"ecm:binarytext"};
        }
        return this.excludes;
    }

    public String[] getIncludes() {
        if (this.includes == null || this.includes.length == 0) {
            return new String[]{"*"};
        }
        return this.includes;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getSettings() {
        return this.settings == null ? DEFAULT_SETTING : this.settings;
    }

    public String getMapping() {
        return this.mapping == null ? DEFAULT_MAPPING : this.mapping;
    }

    public boolean mustCreate() {
        return this.create;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void merge(ElasticSearchIndexConfig other) {
        if (other == null) {
            return;
        }
        if (other.mapping != null) {
            this.mapping = other.mapping;
        }
        if (other.settings != null) {
            this.settings = other.settings;
        }
    }
}

