/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.work;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.core.IndexingMonitor;
import org.nuxeo.elasticsearch.work.BaseIndexingWorker;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractIndexingWorker
extends BaseIndexingWorker {
    private static final long serialVersionUID = 1L;
    protected final List<IndexingCommand> cmds;

    public AbstractIndexingWorker(IndexingMonitor monitor, IndexingCommand cmd) {
        super(monitor);
        this.cmds = new ArrayList<IndexingCommand>(1);
        this.cmds.add(cmd);
        this.repositoryName = cmd.getRepositoryName();
        this.docId = cmd.getTargetDocumentId();
    }

    public AbstractIndexingWorker(IndexingMonitor monitor, String repositoryName, List<IndexingCommand> cmds) {
        super(monitor);
        this.cmds = cmds;
        this.repositoryName = repositoryName;
        if (!cmds.isEmpty()) {
            this.docId = cmds.get(0).getTargetDocumentId();
        }
    }

    @Override
    public void doWork() throws Exception {
        this.initSession();
        for (IndexingCommand cmd : this.cmds) {
            cmd.attach(this.session);
        }
        ElasticSearchIndexing esi = (ElasticSearchIndexing)Framework.getLocalService(ElasticSearchIndexing.class);
        this.doIndexingWork(esi, this.cmds);
    }

    protected abstract void doIndexingWork(ElasticSearchIndexing var1, List<IndexingCommand> var2);
}

