/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.work;

import javax.validation.constraints.NotNull;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.core.IndexingMonitor;
import org.nuxeo.runtime.api.Framework;

public abstract class BaseIndexingWorker
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    protected transient IndexingMonitor monitor;

    BaseIndexingWorker(IndexingMonitor monitor) {
        monitor.incrementWorker();
        this.monitor = monitor;
    }

    public String getCategory() {
        return "elasticSearchIndexing";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void work() throws Exception {
        this.getMonitor().incrementRunningWorker();
        try {
            this.doWork();
        }
        finally {
            this.getMonitor().decrementWorker();
        }
    }

    protected abstract void doWork() throws Exception;

    @NotNull
    public IndexingMonitor getMonitor() {
        if (this.monitor == null) {
            ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getLocalService(ElasticSearchAdmin.class);
            this.monitor = esa.getIndexingMonitor();
        }
        return this.monitor;
    }
}

