/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import com.sun.faces.facelets.tag.TagAttributeImpl;
import com.sun.faces.facelets.tag.TagAttributesImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.ConverterConfig;
import javax.faces.view.facelets.ConverterHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.ValidatorConfig;
import javax.faces.view.facelets.ValidatorHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.actions.NuxeoLayoutManagerBean;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetSelectOption;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetSelectOptions;
import org.nuxeo.ecm.platform.forms.layout.facelets.LeafFaceletHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.ValueExpressionHelper;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasTagHandler;
import org.nuxeo.ecm.platform.ui.web.tag.fn.Functions;
import org.nuxeo.ecm.platform.ui.web.tag.handler.GenericHtmlComponentHandler;
import org.nuxeo.ecm.platform.ui.web.tag.handler.SetTagHandler;
import org.nuxeo.ecm.platform.ui.web.tag.handler.TagConfigFactory;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.api.Framework;

public final class FaceletHandlerHelper {
    private static final Log log = LogFactory.getLog(FaceletHandlerHelper.class);
    public static final String LAYOUT_ID_PREFIX = "nxl_";
    public static final String WIDGET_ID_PREFIX = "nxw_";
    public static final String MESSAGE_ID_SUFFIX = "_message";
    public static final String DEV_CONTAINER_ID_SUFFIX = "_dev_container";
    public static final String DEV_REGION_ID_SUFFIX = "_dev_region";
    public static String DEV_MODE_DISABLED_VARIABLE = "nuxeoLayoutDevModeDisabled";
    static final String LAYOUT_ID_COUNTERS = "org.nuxeo.ecm.platform.layouts.LAYOUT_ID_COUNTERS";
    private static final Pattern UNIQUE_ID_STRIP_PATTERN = Pattern.compile("(.*)(_[0-9]+)");
    public static final String DIR_PROPERTY = "dir";
    public static final String DIR_AUTO = "auto";
    final FaceletContext context;
    final TagConfig tagConfig;

    public FaceletHandlerHelper(FaceletContext context, TagConfig tagConfig) {
        this.context = context;
        this.tagConfig = tagConfig;
    }

    public String generateUniqueId() {
        TagAttribute idAttr = this.tagConfig.getTag().getAttributes().get("id");
        String id = idAttr != null ? idAttr.getValue(this.context) : this.context.getFacesContext().getViewRoot().createUniqueId();
        return this.generateUniqueId(id);
    }

    public String generateUniqueId(String base) {
        Map requestMap = this.context.getFacesContext().getExternalContext().getRequestMap();
        HashMap<String, Integer> counters = (HashMap<String, Integer>)requestMap.get(LAYOUT_ID_COUNTERS);
        if (counters == null) {
            counters = new HashMap<String, Integer>();
        }
        String generatedId = FaceletHandlerHelper.generateUniqueId(FaceletHandlerHelper.generateValidIdString(base), counters);
        requestMap.put(LAYOUT_ID_COUNTERS, counters);
        return generatedId;
    }

    protected static String stripUniqueIdBase(String base) {
        Matcher m;
        if (base != null && (m = UNIQUE_ID_STRIP_PATTERN.matcher(base)).matches()) {
            base = m.group(1);
            return FaceletHandlerHelper.stripUniqueIdBase(base);
        }
        return base;
    }

    public static String generateUniqueId(String base, Map<String, Integer> counters) {
        Integer cnt = counters.get(base = FaceletHandlerHelper.stripUniqueIdBase(base));
        if (cnt == null) {
            counters.put(base, new Integer(0));
            return base;
        }
        int i = cnt + 1;
        counters.put(base, new Integer(i));
        return base + "_" + i;
    }

    protected static String generateValidIdString(String base) {
        if (base == null) {
            throw new IllegalArgumentException(base);
        }
        int n = base.length();
        if (n < 1) {
            throw new IllegalArgumentException(base);
        }
        return Functions.jsfTagIdEscape((String)base);
    }

    public String generateWidgetId(String widgetName) {
        return this.generateUniqueId(WIDGET_ID_PREFIX + widgetName);
    }

    public String generateLayoutId(String layoutName) {
        return this.generateUniqueId(LAYOUT_ID_PREFIX + layoutName);
    }

    public String generateMessageId(String widgetName) {
        return this.generateUniqueId(WIDGET_ID_PREFIX + widgetName + MESSAGE_ID_SUFFIX);
    }

    public String generateDevRegionId(String widgetName) {
        return this.generateUniqueId(WIDGET_ID_PREFIX + widgetName + DEV_REGION_ID_SUFFIX);
    }

    public String generateDevContainerId(String widgetName) {
        return this.generateUniqueId(WIDGET_ID_PREFIX + widgetName + DEV_CONTAINER_ID_SUFFIX);
    }

    public TagAttribute createIdAttribute(String base) {
        String value = this.generateUniqueId(base);
        return new TagAttributeImpl(this.tagConfig.getTag().getLocation(), "", "id", "id", value);
    }

    public TagAttribute createAttribute(String name, String value) {
        if (value == null || value instanceof String) {
            return new TagAttributeImpl(this.tagConfig.getTag().getLocation(), "", name, name, value);
        }
        return null;
    }

    public boolean shouldCreateReferenceAttribute(String key, Serializable value) {
        return !(value instanceof String) || !ComponentTagUtils.isValueReference((String)((String)((Object)value))) && !"converter".equals(key) && !"validator".equals(key) && !"size".equals(key) && !"showApplyButton".equals(key) && !"defaultTime".equals(key);
    }

    public static TagAttributes getTagAttributes(TagAttribute ... attributes) {
        if (attributes == null || attributes.length == 0) {
            return new TagAttributesImpl(new TagAttribute[0]);
        }
        return new TagAttributesImpl(attributes);
    }

    public static TagAttributes getTagAttributes(List<TagAttribute> attributes) {
        return FaceletHandlerHelper.getTagAttributes(attributes.toArray(new TagAttribute[0]));
    }

    public static TagAttributes addTagAttribute(TagAttributes orig, TagAttribute newAttr) {
        if (orig == null) {
            return new TagAttributesImpl(new TagAttribute[]{newAttr});
        }
        ArrayList<TagAttribute> allAttrs = new ArrayList<TagAttribute>(Arrays.asList(orig.getAll()));
        allAttrs.add(newAttr);
        return FaceletHandlerHelper.getTagAttributes(allAttrs);
    }

    public TagAttributes copyTagAttributes(String id, String ... names) {
        ArrayList<TagAttribute> list = new ArrayList<TagAttribute>();
        list.add(this.createIdAttribute(id));
        for (String name : names) {
            TagAttribute attr;
            if ("id".equals(name) || (attr = this.tagConfig.getTag().getAttributes().get(name)) == null) continue;
            list.add(attr);
        }
        TagAttribute[] attrs = list.toArray(new TagAttribute[list.size()]);
        return new TagAttributesImpl(attrs);
    }

    public TagAttributes getTagAttributes(String id, Widget widget) {
        TagAttributes widgetAttrs = this.getTagAttributes(widget);
        return FaceletHandlerHelper.addTagAttribute(widgetAttrs, this.createAttribute("id", id));
    }

    public TagAttributes getTagAttributes(Widget widget) {
        return this.getTagAttributes(widget, null, true);
    }

    public TagAttributes getTagAttributes(Widget widget, List<String> excludedProperties, boolean bindFirstFieldDefinition) {
        return this.getTagAttributes(widget, excludedProperties, bindFirstFieldDefinition, false);
    }

    public TagAttributes getTagAttributes(Widget widget, List<String> excludedProperties, boolean bindFirstFieldDefinition, boolean defaultToValue) {
        List<TagAttribute> propertyAttrs;
        ArrayList<TagAttribute> attrs = new ArrayList<TagAttribute>();
        if (bindFirstFieldDefinition) {
            FieldDefinition field = null;
            FieldDefinition[] fields = widget.getFieldDefinitions();
            if (fields != null && fields.length > 0) {
                field = fields[0];
            }
            if (field != null || defaultToValue) {
                TagAttribute valueAttr = this.createAttribute("value", ValueExpressionHelper.createExpressionString(widget.getValueName(), field));
                attrs.add(valueAttr);
            }
        }
        if ((propertyAttrs = this.getTagAttributes(widget.getProperties(), excludedProperties, true, widget.getType(), widget.getTypeCategory(), widget.getMode())) != null) {
            attrs.addAll(propertyAttrs);
        }
        return FaceletHandlerHelper.getTagAttributes(attrs);
    }

    public List<TagAttribute> getTagAttributes(Map<String, Serializable> properties, List<String> excludedProperties, boolean useReferenceProperties, String widgetType, String widgetTypeCategory, String widgetMode) {
        WebLayoutManager service = null;
        try {
            service = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        if (service == null) {
            throw new FacesException("Layout service not found");
        }
        ArrayList<TagAttribute> attrs = new ArrayList<TagAttribute>();
        if (properties != null) {
            for (Map.Entry<String, Serializable> prop : properties.entrySet()) {
                String key = prop.getKey();
                if (excludedProperties != null && excludedProperties.contains(key)) continue;
                Serializable valueInstance = prop.getValue();
                TagAttribute attr = !useReferenceProperties || !service.referencePropertyAsExpression(key, valueInstance, widgetType, widgetTypeCategory, widgetMode, null) ? (valueInstance == null || valueInstance instanceof String ? this.createAttribute(key, (String)((Object)valueInstance)) : this.createAttribute(key, valueInstance.toString())) : this.createAttribute(key, String.format("#{%s.properties.%s}", RenderVariables.widgetVariables.widget.name(), key));
                attrs.add(attr);
            }
        }
        return attrs;
    }

    public TagAttributes getTagAttributes(WidgetSelectOption selectOption, Map<String, Serializable> additionalProps) {
        List<Object> attrs;
        Map<String, Serializable> props = this.getSelectOptionProperties(selectOption);
        if (additionalProps != null) {
            props.putAll(additionalProps);
        }
        if ((attrs = this.getTagAttributes(props, null, false, null, null, null)) == null) {
            attrs = Collections.emptyList();
        }
        return FaceletHandlerHelper.getTagAttributes(attrs);
    }

    public TagAttributes getTagAttributes(WidgetSelectOption selectOption) {
        return this.getTagAttributes(selectOption, null);
    }

    public Map<String, Serializable> getSelectOptionProperties(WidgetSelectOption selectOption) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        if (selectOption != null) {
            Serializable itemRendered;
            Serializable itemDisabled;
            String itemValue;
            String itemLabel;
            String var;
            Serializable value = selectOption.getValue();
            if (value != null) {
                map.put("value", value);
            }
            if ((var = selectOption.getVar()) != null) {
                map.put("var", (Serializable)((Object)var));
            }
            if ((itemLabel = selectOption.getItemLabel()) != null) {
                map.put("itemLabel", (Serializable)((Object)itemLabel));
            }
            if ((itemValue = selectOption.getItemValue()) != null) {
                map.put("itemValue", (Serializable)((Object)itemValue));
            }
            if ((itemDisabled = selectOption.getItemDisabled()) != null) {
                map.put("itemDisabled", itemDisabled);
            }
            if ((itemRendered = selectOption.getItemRendered()) != null) {
                map.put("itemRendered", itemRendered);
            }
            if (selectOption instanceof WidgetSelectOptions) {
                String ordering;
                WidgetSelectOptions selectOptions = (WidgetSelectOptions)selectOption;
                Boolean caseSensitive = selectOptions.getCaseSensitive();
                if (caseSensitive != null) {
                    map.put("caseSensitive", caseSensitive);
                }
                if ((ordering = selectOptions.getOrdering()) != null) {
                    map.put("ordering", (Serializable)((Object)ordering));
                }
            }
        }
        return map;
    }

    @Deprecated
    public ComponentHandler getHtmlComponentHandler(TagAttributes attributes, FaceletHandler nextHandler, String componentType, String rendererType) {
        return this.getHtmlComponentHandler(null, attributes, nextHandler, componentType, rendererType);
    }

    public ComponentHandler getHtmlComponentHandler(String tagConfigId, TagAttributes attributes, FaceletHandler nextHandler, String componentType, String rendererType) {
        ComponentConfig config = TagConfigFactory.createComponentConfig((TagConfig)this.tagConfig, (String)tagConfigId, (TagAttributes)attributes, (FaceletHandler)nextHandler, (String)componentType, (String)rendererType);
        return new GenericHtmlComponentHandler(config);
    }

    @Deprecated
    public ComponentHandler getErrorComponentHandler(String errorMessage) {
        return this.getErrorComponentHandler(null, errorMessage);
    }

    public ComponentHandler getErrorComponentHandler(String tagConfigId, String errorMessage) {
        LeafFaceletHandler leaf = new LeafFaceletHandler();
        TagAttribute valueAttr = this.createAttribute("value", "<span style=\"color:red;font-weight:bold;\">ERROR: " + errorMessage + "</span><br />");
        TagAttribute escapeAttr = this.createAttribute("escape", "false");
        ComponentHandler output = this.getHtmlComponentHandler(tagConfigId, FaceletHandlerHelper.getTagAttributes(valueAttr, escapeAttr), leaf, "javax.faces.HtmlOutputText", null);
        return output;
    }

    @Deprecated
    public ConverterHandler getConvertHandler(TagAttributes attributes, FaceletHandler nextHandler, String converterId) {
        return this.getConvertHandler(null, attributes, nextHandler, converterId);
    }

    public ConverterHandler getConvertHandler(String tagConfigId, TagAttributes attributes, FaceletHandler nextHandler, String converterId) {
        ConverterConfig config = TagConfigFactory.createConverterConfig((TagConfig)this.tagConfig, (String)tagConfigId, (TagAttributes)attributes, (FaceletHandler)nextHandler, (String)converterId);
        return new ConverterHandler(config);
    }

    @Deprecated
    public ValidatorHandler getValidateHandler(TagAttributes attributes, FaceletHandler nextHandler, String validatorId) {
        return this.getValidateHandler(null, attributes, nextHandler, validatorId);
    }

    public ValidatorHandler getValidateHandler(String tagConfigId, TagAttributes attributes, FaceletHandler nextHandler, String validatorId) {
        ValidatorConfig config = TagConfigFactory.createValidatorConfig((TagConfig)this.tagConfig, (String)tagConfigId, (TagAttributes)attributes, (FaceletHandler)nextHandler, (String)validatorId);
        return new ValidatorHandler(config);
    }

    @Deprecated
    public ComponentHandler getMessageComponentHandler(String id, String forId, String styleClass) {
        return this.getMessageComponentHandler(null, id, forId, styleClass);
    }

    public ComponentHandler getMessageComponentHandler(String tagConfigId, String id, String forId, String styleClass) {
        TagAttribute forAttr = this.createAttribute("for", forId);
        TagAttribute idAttr = this.createAttribute("id", id);
        if (styleClass == null) {
            styleClass = "errorMessage";
        }
        TagAttribute styleAttr = this.createAttribute("styleClass", styleClass);
        TagAttributes attributes = FaceletHandlerHelper.getTagAttributes(forAttr, idAttr, styleAttr);
        ComponentConfig config = TagConfigFactory.createComponentConfig((TagConfig)this.tagConfig, (String)tagConfigId, (TagAttributes)attributes, (FaceletHandler)new LeafFaceletHandler(), (String)"javax.faces.HtmlMessage", null);
        return new ComponentHandler(config);
    }

    public FaceletHandler getAliasTagHandler(String tagConfigId, Map<String, ValueExpression> variables, List<String> blockedPatterns, FaceletHandler nextHandler) {
        FaceletHandler currentHandler = nextHandler;
        if (variables != null) {
            ComponentConfig config = TagConfigFactory.createAliasTagConfig((TagConfig)this.tagConfig, (String)tagConfigId, (TagAttributes)FaceletHandlerHelper.getTagAttributes(new TagAttribute[0]), (FaceletHandler)nextHandler);
            currentHandler = new AliasTagHandler(config, variables, blockedPatterns);
        }
        return currentHandler;
    }

    public static boolean isDevModeEnabled(FaceletContext ctx) {
        ExpressionFactory eFactory;
        ValueExpression disableDevAttr;
        NuxeoLayoutManagerBean bean;
        return Framework.isDevModeSet() && (bean = FaceletHandlerHelper.lookupBean(ctx.getFacesContext())).isDevModeSet() && !Boolean.TRUE.equals((disableDevAttr = (eFactory = ctx.getExpressionFactory()).createValueExpression((ELContext)ctx, String.format("#{%s}", DEV_MODE_DISABLED_VARIABLE), Boolean.class)).getValue((ELContext)ctx));
    }

    protected static NuxeoLayoutManagerBean lookupBean(FacesContext ctx) {
        String expr = "#{nuxeoLayoutManagerBean}";
        NuxeoLayoutManagerBean bean = (NuxeoLayoutManagerBean)ctx.getApplication().evaluateExpressionGet(ctx, expr, Object.class);
        if (bean == null) {
            log.error((Object)("Managed bean not found: " + expr));
            return null;
        }
        return bean;
    }

    public FaceletHandler getDisableDevModeTagHandler(String tagConfigId, FaceletHandler nextHandler) {
        ComponentConfig config = TagConfigFactory.createAliasTagConfig((TagConfig)this.tagConfig, (String)tagConfigId, (String)DEV_MODE_DISABLED_VARIABLE, (String)"true", (String)"true", (String)"false", (FaceletHandler)nextHandler);
        return new SetTagHandler(config);
    }
}

