/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.seam;

import java.lang.reflect.Field;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Seam;
import org.jboss.seam.core.Init;
import org.jboss.seam.init.Initialization;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.ServerLocator;

public class SeamHotReloadHelper {
    private static final Log log = LogFactory.getLog(SeamHotReloadHelper.class);
    @Deprecated
    public static final String SEAM_HOT_RELOAD_SYSTEM_PROP = "org.nuxeo.seam.debug";

    public static boolean isHotReloadEnabled() {
        String sysProp = System.getProperty(SEAM_HOT_RELOAD_SYSTEM_PROP, "false");
        return Boolean.TRUE.equals(Boolean.valueOf(sysProp));
    }

    public static void flush() {
        Seam.clearComponentNameCache();
        try {
            Field f = Seam.class.getDeclaredField("CLASSLOADERS_LOADED");
            f.setAccessible(true);
            ((Set)f.get(null)).clear();
        }
        catch (Exception e) {
            log.warn((Object)"Can't flush seam class loader cache", (Throwable)e);
        }
        try {
            SeamHotReloadHelper.flushWebResources();
        }
        catch (Exception e) {
            log.error((Object)"Cannot flush web resources, did you start with the sdk profile active ?", (Throwable)e);
        }
    }

    public static Set<String> reloadSeamComponents(HttpServletRequest httpRequest) {
        ServletContext servletContext = httpRequest.getSession().getServletContext();
        Init init = (Init)servletContext.getAttribute(Seam.getComponentName(Init.class));
        if (init != null && init.hasHotDeployableComponents()) {
            try {
                new Initialization(servletContext).redeploy(httpRequest);
            }
            catch (InterruptedException e) {
                log.error((Object)"Error during hot redeploy", (Throwable)e);
            }
        }
        return init.getHotDeployableComponents();
    }

    public static Set<String> getHotDeployableComponents(HttpServletRequest httpRequest) {
        ServletContext servletContext = httpRequest.getSession().getServletContext();
        Init init = (Init)servletContext.getAttribute(Seam.getComponentName(Init.class));
        return init.getHotDeployableComponents();
    }

    protected static void flushWebResources() throws MalformedObjectNameException, ReflectionException, InstanceNotFoundException, MBeanException {
        ObjectName on = new ObjectName("org.nuxeo:type=sdk,name=web-resources");
        MBeanServer mbs = ((ServerLocator)Framework.getLocalService(ServerLocator.class)).lookupServer();
        if (mbs.isRegistered(on)) {
            mbs.invoke(on, "flushWebResources", new Object[0], new String[0]);
        }
    }
}

