/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.extension;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.nuxeo.common.Environment;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="configuration")
public class GlobalConfigDescriptor
implements Serializable {
    public static final long DEFAULT_GC_INTERVAL_IN_MIN = 10L;
    public static final int DEFAULT_DISK_CACHE_IN_KB = 10240;
    private static final String CACHING_DIRECTORY = "convertcache";
    private static final long serialVersionUID = 1L;
    protected long GCInterval = 10L;
    protected int diskCacheSize = 10240;
    @XNode(value="enableCache")
    protected boolean enableCache = true;
    @XNode(value="cachingDirectory")
    protected String cachingDirectory = this.defaultCachingDirectory().getAbsolutePath();

    public long getGCInterval() {
        return this.GCInterval;
    }

    @XNode(value="gcInterval")
    public void setGCInterval(long value) {
        this.GCInterval = value == 0L ? 10L : value;
    }

    public int getDiskCacheSize() {
        return this.diskCacheSize;
    }

    @XNode(value="diskCacheSize")
    public void setDiskCacheSize(int size) {
        this.diskCacheSize = size == 0 ? 10240 : size;
    }

    public boolean isCacheEnabled() {
        return this.enableCache;
    }

    public void update(GlobalConfigDescriptor other) {
        if (other.GCInterval != 10L) {
            this.GCInterval = other.GCInterval;
        }
        if ((long)other.diskCacheSize != 10L) {
            this.diskCacheSize = other.diskCacheSize;
        }
        if (other.cachingDirectory != this.defaultCachingDirectory().getAbsolutePath()) {
            this.cachingDirectory = other.cachingDirectory;
        }
        this.enableCache = other.enableCache;
    }

    protected File defaultCachingDirectory() {
        File data = new File(Environment.getDefault().getData(), CACHING_DIRECTORY);
        if (data.exists()) {
            try {
                FileUtils.deleteDirectory((File)data);
            }
            catch (IOException cause) {
                throw new RuntimeException("Cannot create cache dir " + data, cause);
            }
        }
        data.mkdirs();
        return data.getAbsoluteFile();
    }

    public String getCachingDirectory() {
        return this.cachingDirectory;
    }
}

