/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints;

import java.math.BigInteger;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.IPBConstructor;
import org.sat4j.pb.constraints.MinLongWatchPBConstructor;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.MinWatchPb;
import org.sat4j.pb.constraints.pb.MinWatchPbLongCP;
import org.sat4j.specs.ContradictionException;

public class MinLongWatchPBCPConstructor
implements IPBConstructor {
    public Constr constructLearntPB(ILits voc, IDataStructurePB dspb) {
        if (dspb.isLongSufficient()) {
            return MinWatchPbLongCP.normalizedWatchPbNew(voc, dspb);
        }
        return MinWatchPb.normalizedWatchPbNew(voc, dspb);
    }

    public Constr constructPB(UnitPropagationListener solver, ILits voc, int[] theLits, BigInteger[] coefs, BigInteger degree) throws ContradictionException {
        if (MinLongWatchPBConstructor.isLongSufficient(coefs, degree)) {
            return MinWatchPbLongCP.normalizedMinWatchPbNew(solver, voc, theLits, coefs, degree);
        }
        return MinWatchPb.normalizedMinWatchPbNew(solver, voc, theLits, coefs, degree);
    }
}

