/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.utils;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.parent.IChildrenProvider;
import com.phloc.commons.string.StringHelper;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ChildrenProviderElementWithName
implements IChildrenProvider<IMicroElement> {
    private final String m_sNamespaceURI;
    private final String m_sTagName;

    public ChildrenProviderElementWithName(@Nonnull @Nonempty String string) {
        this(null, string);
    }

    public ChildrenProviderElementWithName(@Nullable String string, @Nonnull @Nonempty String string2) {
        if (StringHelper.hasNoText(string2)) {
            throw new IllegalArgumentException("tagName");
        }
        this.m_sNamespaceURI = string;
        this.m_sTagName = string2;
    }

    @Override
    public boolean hasChildren(@Nullable IMicroElement iMicroElement) {
        if (iMicroElement == null || !iMicroElement.isElement()) {
            return false;
        }
        if (StringHelper.hasText(this.m_sNamespaceURI)) {
            return iMicroElement.hasChildElements(this.m_sNamespaceURI, this.m_sTagName);
        }
        return iMicroElement.hasChildElements(this.m_sTagName);
    }

    @Override
    @Nonnegative
    public int getChildCount(@Nullable IMicroElement iMicroElement) {
        return iMicroElement == null ? 0 : this.getChildren(iMicroElement).size();
    }

    @Override
    @Nonnull
    public Collection<? extends IMicroElement> getChildren(@Nullable IMicroElement iMicroElement) {
        if (iMicroElement == null) {
            return new ArrayList();
        }
        if (StringHelper.hasText(this.m_sNamespaceURI)) {
            return iMicroElement.getChildElements(this.m_sNamespaceURI, this.m_sTagName);
        }
        return iMicroElement.getChildElements(this.m_sTagName);
    }
}

