/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.IntCollection;
import org.apache.commons.collections.primitives.IntIterator;
import org.apache.commons.collections.primitives.RandomAccessIntList;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class ArrayIntList
extends RandomAccessIntList
implements Serializable {
    private transient int[] _data;
    private int _size;

    public ArrayIntList() {
        this(8);
    }

    public ArrayIntList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity " + n);
        }
        this._data = new int[n];
        this._size = 0;
    }

    public ArrayIntList(@Nonnull IntCollection intCollection) {
        this(intCollection.size());
        this.addAll(intCollection);
    }

    public ArrayIntList(@Nonnull int[] nArray) {
        this(nArray.length);
        System.arraycopy(nArray, 0, this._data, 0, nArray.length);
        this._size = nArray.length;
    }

    @Override
    public int get(int n) {
        this._checkRange(n);
        return this._data[n];
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public int removeElementAt(int n) {
        this._checkRange(n);
        this.incrModCount();
        int n2 = this._data[n];
        int n3 = this._size - n - 1;
        if (n3 > 0) {
            System.arraycopy(this._data, n + 1, this._data, n, n3);
        }
        --this._size;
        return n2;
    }

    @Override
    public int set(int n, int n2) {
        this._checkRange(n);
        this.incrModCount();
        int n3 = this._data[n];
        this._data[n] = n2;
        return n3;
    }

    @Override
    public void add(int n, int n2) {
        this._checkRangeIncludingEndpoint(n);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int n3 = this._size - n;
        System.arraycopy(this._data, n, this._data, n + 1, n3);
        this._data[n] = n2;
        ++this._size;
    }

    @Override
    public void clear() {
        this.incrModCount();
        this._size = 0;
    }

    @Override
    public boolean addAll(@Nonnull IntCollection intCollection) {
        return this.addAll(this.size(), intCollection);
    }

    @Override
    public boolean addAll(int n, @Nonnull IntCollection intCollection) {
        if (intCollection.size() == 0) {
            return false;
        }
        int n2 = n;
        this._checkRangeIncludingEndpoint(n2);
        this.incrModCount();
        this.ensureCapacity(this._size + intCollection.size());
        if (n2 != this._size) {
            System.arraycopy(this._data, n2, this._data, n2 + intCollection.size(), this._size - n2);
        }
        IntIterator intIterator = intCollection.iterator();
        while (intIterator.hasNext()) {
            this._data[n2] = intIterator.next();
            ++n2;
        }
        this._size += intCollection.size();
        return true;
    }

    public void ensureCapacity(int n) {
        this.incrModCount();
        if (n > this._data.length) {
            int n2 = this._data.length * 3 / 2 + 1;
            int[] nArray = this._data;
            this._data = new int[n2 < n ? n : n2];
            System.arraycopy(nArray, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            int[] nArray = this._data;
            this._data = new int[this._size];
            System.arraycopy(nArray, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            objectOutputStream.writeInt(this._data[i]);
        }
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._data = new int[objectInputStream.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = objectInputStream.readInt();
        }
    }

    private final void _checkRange(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + n);
        }
    }

    private final void _checkRangeIncludingEndpoint(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + n);
        }
    }
}

