/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.ArrayByteList;
import org.apache.commons.collections.primitives.ByteIterator;
import org.apache.commons.collections.primitives.ByteList;
import org.apache.commons.collections.primitives.ByteListIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableByteIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableByteList;
import org.apache.commons.collections.primitives.decorators.UnmodifiableByteListIterator;

public final class ByteCollections {
    public static final ByteList EMPTY_BYTE_LIST = ByteCollections.unmodifiableByteList(new ArrayByteList(0));
    public static final ByteIterator EMPTY_BYTE_ITERATOR = ByteCollections.unmodifiableByteIterator(EMPTY_BYTE_LIST.iterator());
    public static final ByteListIterator EMPTY_BYTE_LIST_ITERATOR = ByteCollections.unmodifiableByteListIterator(EMPTY_BYTE_LIST.listIterator());

    private ByteCollections() {
    }

    @Nonnull
    public static ByteList singletonByteList(byte by) {
        ArrayByteList arrayByteList = new ArrayByteList(1);
        arrayByteList.add(by);
        return UnmodifiableByteList.wrap(arrayByteList);
    }

    @Nonnull
    public static ByteIterator singletonByteIterator(byte by) {
        return ByteCollections.singletonByteList(by).iterator();
    }

    @Nonnull
    public static ByteListIterator singletonByteListIterator(byte by) {
        return ByteCollections.singletonByteList(by).listIterator();
    }

    @Nonnull
    public static ByteList unmodifiableByteList(@Nonnull ByteList byteList) throws NullPointerException {
        if (null == byteList) {
            throw new NullPointerException();
        }
        return UnmodifiableByteList.wrap(byteList);
    }

    @Nonnull
    public static ByteIterator unmodifiableByteIterator(@Nonnull ByteIterator byteIterator) {
        if (null == byteIterator) {
            throw new NullPointerException();
        }
        return UnmodifiableByteIterator.wrap(byteIterator);
    }

    @Nonnull
    public static ByteListIterator unmodifiableByteListIterator(@Nonnull ByteListIterator byteListIterator) {
        if (null == byteListIterator) {
            throw new NullPointerException();
        }
        return UnmodifiableByteListIterator.wrap(byteListIterator);
    }

    @Nonnull
    public static ByteList getEmptyByteList() {
        return EMPTY_BYTE_LIST;
    }

    @Nonnull
    public static ByteIterator getEmptyByteIterator() {
        return EMPTY_BYTE_ITERATOR;
    }

    @Nonnull
    public static ByteListIterator getEmptyByteListIterator() {
        return EMPTY_BYTE_LIST_ITERATOR;
    }
}

